package zio.aws.kafka.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{MaxResults, __string}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListClustersV2Request(
    clusterNameFilter: Optional[__string] = Optional.Absent,
    clusterTypeFilter: Optional[__string] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClustersV2Request = {
    import ListClustersV2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClustersV2Request
      .builder()
      .optionallyWith(clusterNameFilter.map(value => value: java.lang.String))(
        _.clusterNameFilter
      )
      .optionallyWith(clusterTypeFilter.map(value => value: java.lang.String))(
        _.clusterTypeFilter
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListClustersV2Request.ReadOnly =
    zio.aws.kafka.model.ListClustersV2Request.wrap(buildAwsValue())
}
object ListClustersV2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClustersV2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClustersV2Request =
      zio.aws.kafka.model.ListClustersV2Request(
        clusterNameFilter.map(value => value),
        clusterTypeFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterNameFilter: Optional[__string]
    def clusterTypeFilter: Optional[__string]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getClusterNameFilter: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterNameFilter", clusterNameFilter)
    def getClusterTypeFilter: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterTypeFilter", clusterTypeFilter)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersV2Request
  ) extends zio.aws.kafka.model.ListClustersV2Request.ReadOnly {
    override val clusterNameFilter: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterNameFilter())
      .map(value => value: __string)
    override val clusterTypeFilter: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterTypeFilter())
      .map(value => value: __string)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.kafka.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersV2Request
  ): zio.aws.kafka.model.ListClustersV2Request.ReadOnly = new Wrapper(impl)
}
