package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Firehose(
    deliveryStream: Optional[__string] = Optional.Absent,
    enabled: __boolean
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.Firehose = {
    import Firehose.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Firehose
      .builder()
      .optionallyWith(deliveryStream.map(value => value: java.lang.String))(
        _.deliveryStream
      )
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Firehose.ReadOnly =
    zio.aws.kafka.model.Firehose.wrap(buildAwsValue())
}
object Firehose {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.Firehose] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Firehose =
      zio.aws.kafka.model.Firehose(deliveryStream.map(value => value), enabled)
    def deliveryStream: Optional[__string]
    def enabled: __boolean
    def getDeliveryStream: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("deliveryStream", deliveryStream)
    def getEnabled: ZIO[Any, Nothing, __boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Firehose
  ) extends zio.aws.kafka.model.Firehose.ReadOnly {
    override val deliveryStream: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.deliveryStream())
      .map(value => value: __string)
    override val enabled: __boolean = impl.enabled(): __boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Firehose
  ): zio.aws.kafka.model.Firehose.ReadOnly = new Wrapper(impl)
}
