package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__blob, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConfigurationRequest(
    description: Optional[__string] = Optional.Absent,
    kafkaVersions: Optional[Iterable[__string]] = Optional.Absent,
    name: __string,
    serverProperties: __blob
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateConfigurationRequest = {
    import CreateConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateConfigurationRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        kafkaVersions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.kafkaVersions)
      .name(name: java.lang.String)
      .serverProperties(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(serverProperties.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateConfigurationRequest.ReadOnly =
    zio.aws.kafka.model.CreateConfigurationRequest.wrap(buildAwsValue())
}
object CreateConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateConfigurationRequest =
      zio.aws.kafka.model.CreateConfigurationRequest(
        description.map(value => value),
        kafkaVersions.map(value => value),
        name,
        serverProperties
      )
    def description: Optional[__string]
    def kafkaVersions: Optional[List[__string]]
    def name: __string
    def serverProperties: __blob
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getKafkaVersions: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("kafkaVersions", kafkaVersions)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getServerProperties: ZIO[Any, Nothing, __blob] =
      ZIO.succeed(serverProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateConfigurationRequest
  ) extends zio.aws.kafka.model.CreateConfigurationRequest.ReadOnly {
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val kafkaVersions: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.kafkaVersions())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val name: __string = impl.name(): __string
    override val serverProperties: __blob =
      zio.Chunk.fromArray(impl.serverProperties().asByteArrayUnsafe()): __blob
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateConfigurationRequest
  ): zio.aws.kafka.model.CreateConfigurationRequest.ReadOnly = new Wrapper(impl)
}
