package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__double, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ZookeeperNodeInfo(
    attachedENIId: Optional[__string] = Optional.Absent,
    clientVpcIpAddress: Optional[__string] = Optional.Absent,
    endpoints: Optional[Iterable[__string]] = Optional.Absent,
    zookeeperId: Optional[__double] = Optional.Absent,
    zookeeperVersion: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ZookeeperNodeInfo = {
    import ZookeeperNodeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ZookeeperNodeInfo
      .builder()
      .optionallyWith(attachedENIId.map(value => value: java.lang.String))(
        _.attachedENIId
      )
      .optionallyWith(clientVpcIpAddress.map(value => value: java.lang.String))(
        _.clientVpcIpAddress
      )
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.endpoints)
      .optionallyWith(zookeeperId.map(value => value: java.lang.Double))(
        _.zookeeperId
      )
      .optionallyWith(zookeeperVersion.map(value => value: java.lang.String))(
        _.zookeeperVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly =
    zio.aws.kafka.model.ZookeeperNodeInfo.wrap(buildAwsValue())
}
object ZookeeperNodeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ZookeeperNodeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ZookeeperNodeInfo =
      zio.aws.kafka.model.ZookeeperNodeInfo(
        attachedENIId.map(value => value),
        clientVpcIpAddress.map(value => value),
        endpoints.map(value => value),
        zookeeperId.map(value => value),
        zookeeperVersion.map(value => value)
      )
    def attachedENIId: Optional[__string]
    def clientVpcIpAddress: Optional[__string]
    def endpoints: Optional[List[__string]]
    def zookeeperId: Optional[__double]
    def zookeeperVersion: Optional[__string]
    def getAttachedENIId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("attachedENIId", attachedENIId)
    def getClientVpcIpAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientVpcIpAddress", clientVpcIpAddress)
    def getEndpoints: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getZookeeperId: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("zookeeperId", zookeeperId)
    def getZookeeperVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("zookeeperVersion", zookeeperVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ZookeeperNodeInfo
  ) extends zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly {
    override val attachedENIId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.attachedENIId())
      .map(value => value: __string)
    override val clientVpcIpAddress: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientVpcIpAddress())
      .map(value => value: __string)
    override val endpoints: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoints())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val zookeeperId: Optional[__double] = zio.aws.core.internal
      .optionalFromNullable(impl.zookeeperId())
      .map(value => value: __double)
    override val zookeeperVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.zookeeperVersion())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ZookeeperNodeInfo
  ): zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly = new Wrapper(impl)
}
