package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StateInfo(
    code: Optional[__string] = Optional.Absent,
    message: Optional[__string] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.StateInfo = {
    import StateInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.StateInfo
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.StateInfo.ReadOnly =
    zio.aws.kafka.model.StateInfo.wrap(buildAwsValue())
}
object StateInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.StateInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.StateInfo = zio.aws.kafka.model
      .StateInfo(code.map(value => value), message.map(value => value))
    def code: Optional[__string]
    def message: Optional[__string]
    def getCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.StateInfo
  ) extends zio.aws.kafka.model.StateInfo.ReadOnly {
    override val code: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: __string)
    override val message: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.StateInfo
  ): zio.aws.kafka.model.StateInfo.ReadOnly = new Wrapper(impl)
}
