package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeClusterResponse(
    clusterInfo: Optional[zio.aws.kafka.model.ClusterInfo] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DescribeClusterResponse = {
    import DescribeClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DescribeClusterResponse
      .builder()
      .optionallyWith(clusterInfo.map(value => value.buildAwsValue()))(
        _.clusterInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.DescribeClusterResponse.ReadOnly =
    zio.aws.kafka.model.DescribeClusterResponse.wrap(buildAwsValue())
}
object DescribeClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DescribeClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DescribeClusterResponse =
      zio.aws.kafka.model
        .DescribeClusterResponse(clusterInfo.map(value => value.asEditable))
    def clusterInfo: Optional[zio.aws.kafka.model.ClusterInfo.ReadOnly]
    def getClusterInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ClusterInfo.ReadOnly] =
      AwsError.unwrapOptionField("clusterInfo", clusterInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterResponse
  ) extends zio.aws.kafka.model.DescribeClusterResponse.ReadOnly {
    override val clusterInfo
        : Optional[zio.aws.kafka.model.ClusterInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterInfo())
        .map(value => zio.aws.kafka.model.ClusterInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterResponse
  ): zio.aws.kafka.model.DescribeClusterResponse.ReadOnly = new Wrapper(impl)
}
