package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClientAuthentication(
    sasl: Optional[zio.aws.kafka.model.Sasl] = Optional.Absent,
    tls: Optional[zio.aws.kafka.model.Tls] = Optional.Absent,
    unauthenticated: Optional[zio.aws.kafka.model.Unauthenticated] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClientAuthentication = {
    import ClientAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClientAuthentication
      .builder()
      .optionallyWith(sasl.map(value => value.buildAwsValue()))(_.sasl)
      .optionallyWith(tls.map(value => value.buildAwsValue()))(_.tls)
      .optionallyWith(unauthenticated.map(value => value.buildAwsValue()))(
        _.unauthenticated
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClientAuthentication.ReadOnly =
    zio.aws.kafka.model.ClientAuthentication.wrap(buildAwsValue())
}
object ClientAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ClientAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClientAuthentication =
      zio.aws.kafka.model.ClientAuthentication(
        sasl.map(value => value.asEditable),
        tls.map(value => value.asEditable),
        unauthenticated.map(value => value.asEditable)
      )
    def sasl: Optional[zio.aws.kafka.model.Sasl.ReadOnly]
    def tls: Optional[zio.aws.kafka.model.Tls.ReadOnly]
    def unauthenticated: Optional[zio.aws.kafka.model.Unauthenticated.ReadOnly]
    def getSasl: ZIO[Any, AwsError, zio.aws.kafka.model.Sasl.ReadOnly] =
      AwsError.unwrapOptionField("sasl", sasl)
    def getTls: ZIO[Any, AwsError, zio.aws.kafka.model.Tls.ReadOnly] =
      AwsError.unwrapOptionField("tls", tls)
    def getUnauthenticated
        : ZIO[Any, AwsError, zio.aws.kafka.model.Unauthenticated.ReadOnly] =
      AwsError.unwrapOptionField("unauthenticated", unauthenticated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClientAuthentication
  ) extends zio.aws.kafka.model.ClientAuthentication.ReadOnly {
    override val sasl: Optional[zio.aws.kafka.model.Sasl.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sasl())
        .map(value => zio.aws.kafka.model.Sasl.wrap(value))
    override val tls: Optional[zio.aws.kafka.model.Tls.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tls())
        .map(value => zio.aws.kafka.model.Tls.wrap(value))
    override val unauthenticated
        : Optional[zio.aws.kafka.model.Unauthenticated.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unauthenticated())
        .map(value => zio.aws.kafka.model.Unauthenticated.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClientAuthentication
  ): zio.aws.kafka.model.ClientAuthentication.ReadOnly = new Wrapper(impl)
}
