package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClusterV2Response(
    clusterInfo: Option[zio.aws.kafka.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DescribeClusterV2Response = {
    import DescribeClusterV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DescribeClusterV2Response
      .builder()
      .optionallyWith(clusterInfo.map(value => value.buildAwsValue()))(
        _.clusterInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.DescribeClusterV2Response.ReadOnly =
    zio.aws.kafka.model.DescribeClusterV2Response.wrap(buildAwsValue())
}
object DescribeClusterV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DescribeClusterV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DescribeClusterV2Response =
      zio.aws.kafka.model
        .DescribeClusterV2Response(clusterInfo.map(value => value.asEditable))
    def clusterInfo: Option[zio.aws.kafka.model.Cluster.ReadOnly]
    def getClusterInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("clusterInfo", clusterInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterV2Response
  ) extends zio.aws.kafka.model.DescribeClusterV2Response.ReadOnly {
    override val clusterInfo: Option[zio.aws.kafka.model.Cluster.ReadOnly] =
      scala
        .Option(impl.clusterInfo())
        .map(value => zio.aws.kafka.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterV2Response
  ): zio.aws.kafka.model.DescribeClusterV2Response.ReadOnly = new Wrapper(impl)
}
