package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{__string, __integerMin1Max15}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Provisioned(
    brokerNodeGroupInfo: zio.aws.kafka.model.BrokerNodeGroupInfo,
    currentBrokerSoftwareInfo: Option[zio.aws.kafka.model.BrokerSoftwareInfo] =
      None,
    clientAuthentication: Option[zio.aws.kafka.model.ClientAuthentication] =
      None,
    encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo] = None,
    enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring] = None,
    openMonitoring: Option[zio.aws.kafka.model.OpenMonitoringInfo] = None,
    loggingInfo: Option[zio.aws.kafka.model.LoggingInfo] = None,
    numberOfBrokerNodes: __integerMin1Max15,
    zookeeperConnectString: Option[__string] = None,
    zookeeperConnectStringTls: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.Provisioned = {
    import Provisioned.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Provisioned
      .builder()
      .brokerNodeGroupInfo(brokerNodeGroupInfo.buildAwsValue())
      .optionallyWith(
        currentBrokerSoftwareInfo.map(value => value.buildAwsValue())
      )(_.currentBrokerSoftwareInfo)
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .optionallyWith(encryptionInfo.map(value => value.buildAwsValue()))(
        _.encryptionInfo
      )
      .optionallyWith(enhancedMonitoring.map(value => value.unwrap))(
        _.enhancedMonitoring
      )
      .optionallyWith(openMonitoring.map(value => value.buildAwsValue()))(
        _.openMonitoring
      )
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .numberOfBrokerNodes(numberOfBrokerNodes: Integer)
      .optionallyWith(
        zookeeperConnectString.map(value => value: java.lang.String)
      )(_.zookeeperConnectString)
      .optionallyWith(
        zookeeperConnectStringTls.map(value => value: java.lang.String)
      )(_.zookeeperConnectStringTls)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Provisioned.ReadOnly =
    zio.aws.kafka.model.Provisioned.wrap(buildAwsValue())
}
object Provisioned {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.Provisioned] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Provisioned =
      zio.aws.kafka.model.Provisioned(
        brokerNodeGroupInfo.asEditable,
        currentBrokerSoftwareInfo.map(value => value.asEditable),
        clientAuthentication.map(value => value.asEditable),
        encryptionInfo.map(value => value.asEditable),
        enhancedMonitoring.map(value => value),
        openMonitoring.map(value => value.asEditable),
        loggingInfo.map(value => value.asEditable),
        numberOfBrokerNodes,
        zookeeperConnectString.map(value => value),
        zookeeperConnectStringTls.map(value => value)
      )
    def brokerNodeGroupInfo: zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly
    def currentBrokerSoftwareInfo
        : Option[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly]
    def clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly]
    def encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly]
    def enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring]
    def openMonitoring: Option[zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly]
    def loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly]
    def numberOfBrokerNodes: __integerMin1Max15
    def zookeeperConnectString: Option[__string]
    def zookeeperConnectStringTls: Option[__string]
    def getBrokerNodeGroupInfo
        : ZIO[Any, Nothing, zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly] =
      ZIO.succeed(brokerNodeGroupInfo)
    def getCurrentBrokerSoftwareInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] =
      AwsError.unwrapOptionField(
        "currentBrokerSoftwareInfo",
        currentBrokerSoftwareInfo
      )
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
    def getEncryptionInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      AwsError.unwrapOptionField("encryptionInfo", encryptionInfo)
    def getEnhancedMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.EnhancedMonitoring] =
      AwsError.unwrapOptionField("enhancedMonitoring", enhancedMonitoring)
    def getOpenMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly] =
      AwsError.unwrapOptionField("openMonitoring", openMonitoring)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getNumberOfBrokerNodes: ZIO[Any, Nothing, __integerMin1Max15] =
      ZIO.succeed(numberOfBrokerNodes)
    def getZookeeperConnectString: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("zookeeperConnectString", zookeeperConnectString)
    def getZookeeperConnectStringTls: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("zookeeperConnectStringTls", zookeeperConnectStringTls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Provisioned
  ) extends zio.aws.kafka.model.Provisioned.ReadOnly {
    override val brokerNodeGroupInfo
        : zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly =
      zio.aws.kafka.model.BrokerNodeGroupInfo.wrap(impl.brokerNodeGroupInfo())
    override val currentBrokerSoftwareInfo
        : Option[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] = scala
      .Option(impl.currentBrokerSoftwareInfo())
      .map(value => zio.aws.kafka.model.BrokerSoftwareInfo.wrap(value))
    override val clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly] = scala
      .Option(impl.clientAuthentication())
      .map(value => zio.aws.kafka.model.ClientAuthentication.wrap(value))
    override val encryptionInfo
        : Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly] = scala
      .Option(impl.encryptionInfo())
      .map(value => zio.aws.kafka.model.EncryptionInfo.wrap(value))
    override val enhancedMonitoring
        : Option[zio.aws.kafka.model.EnhancedMonitoring] = scala
      .Option(impl.enhancedMonitoring())
      .map(value => zio.aws.kafka.model.EnhancedMonitoring.wrap(value))
    override val openMonitoring
        : Option[zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly] = scala
      .Option(impl.openMonitoring())
      .map(value => zio.aws.kafka.model.OpenMonitoringInfo.wrap(value))
    override val loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      scala
        .Option(impl.loggingInfo())
        .map(value => zio.aws.kafka.model.LoggingInfo.wrap(value))
    override val numberOfBrokerNodes: __integerMin1Max15 =
      impl.numberOfBrokerNodes(): __integerMin1Max15
    override val zookeeperConnectString: Option[__string] =
      scala.Option(impl.zookeeperConnectString()).map(value => value: __string)
    override val zookeeperConnectStringTls: Option[__string] = scala
      .Option(impl.zookeeperConnectStringTls())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Provisioned
  ): zio.aws.kafka.model.Provisioned.ReadOnly = new Wrapper(impl)
}
