package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{__stringMin5Max32, __string, __integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MutableClusterInfo(
    brokerEBSVolumeInfo: Option[
      Iterable[zio.aws.kafka.model.BrokerEBSVolumeInfo]
    ] = None,
    configurationInfo: Option[zio.aws.kafka.model.ConfigurationInfo] = None,
    numberOfBrokerNodes: Option[__integer] = None,
    enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring] = None,
    openMonitoring: Option[zio.aws.kafka.model.OpenMonitoring] = None,
    kafkaVersion: Option[__string] = None,
    loggingInfo: Option[zio.aws.kafka.model.LoggingInfo] = None,
    instanceType: Option[__stringMin5Max32] = None,
    clientAuthentication: Option[zio.aws.kafka.model.ClientAuthentication] =
      None,
    encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo] = None,
    connectivityInfo: Option[zio.aws.kafka.model.ConnectivityInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.MutableClusterInfo = {
    import MutableClusterInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.MutableClusterInfo
      .builder()
      .optionallyWith(
        brokerEBSVolumeInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.brokerEBSVolumeInfo)
      .optionallyWith(configurationInfo.map(value => value.buildAwsValue()))(
        _.configurationInfo
      )
      .optionallyWith(numberOfBrokerNodes.map(value => value: Integer))(
        _.numberOfBrokerNodes
      )
      .optionallyWith(enhancedMonitoring.map(value => value.unwrap))(
        _.enhancedMonitoring
      )
      .optionallyWith(openMonitoring.map(value => value.buildAwsValue()))(
        _.openMonitoring
      )
      .optionallyWith(kafkaVersion.map(value => value: java.lang.String))(
        _.kafkaVersion
      )
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .optionallyWith(encryptionInfo.map(value => value.buildAwsValue()))(
        _.encryptionInfo
      )
      .optionallyWith(connectivityInfo.map(value => value.buildAwsValue()))(
        _.connectivityInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.MutableClusterInfo.ReadOnly =
    zio.aws.kafka.model.MutableClusterInfo.wrap(buildAwsValue())
}
object MutableClusterInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.MutableClusterInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.MutableClusterInfo =
      zio.aws.kafka.model.MutableClusterInfo(
        brokerEBSVolumeInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationInfo.map(value => value.asEditable),
        numberOfBrokerNodes.map(value => value),
        enhancedMonitoring.map(value => value),
        openMonitoring.map(value => value.asEditable),
        kafkaVersion.map(value => value),
        loggingInfo.map(value => value.asEditable),
        instanceType.map(value => value),
        clientAuthentication.map(value => value.asEditable),
        encryptionInfo.map(value => value.asEditable),
        connectivityInfo.map(value => value.asEditable)
      )
    def brokerEBSVolumeInfo
        : Option[List[zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly]]
    def configurationInfo
        : Option[zio.aws.kafka.model.ConfigurationInfo.ReadOnly]
    def numberOfBrokerNodes: Option[__integer]
    def enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring]
    def openMonitoring: Option[zio.aws.kafka.model.OpenMonitoring.ReadOnly]
    def kafkaVersion: Option[__string]
    def loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly]
    def instanceType: Option[__stringMin5Max32]
    def clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly]
    def encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly]
    def connectivityInfo: Option[zio.aws.kafka.model.ConnectivityInfo.ReadOnly]
    def getBrokerEBSVolumeInfo: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("brokerEBSVolumeInfo", brokerEBSVolumeInfo)
    def getConfigurationInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ConfigurationInfo.ReadOnly] =
      AwsError.unwrapOptionField("configurationInfo", configurationInfo)
    def getNumberOfBrokerNodes: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("numberOfBrokerNodes", numberOfBrokerNodes)
    def getEnhancedMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.EnhancedMonitoring] =
      AwsError.unwrapOptionField("enhancedMonitoring", enhancedMonitoring)
    def getOpenMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.OpenMonitoring.ReadOnly] =
      AwsError.unwrapOptionField("openMonitoring", openMonitoring)
    def getKafkaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("kafkaVersion", kafkaVersion)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getInstanceType: ZIO[Any, AwsError, __stringMin5Max32] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
    def getEncryptionInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      AwsError.unwrapOptionField("encryptionInfo", encryptionInfo)
    def getConnectivityInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ConnectivityInfo.ReadOnly] =
      AwsError.unwrapOptionField("connectivityInfo", connectivityInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.MutableClusterInfo
  ) extends zio.aws.kafka.model.MutableClusterInfo.ReadOnly {
    override val brokerEBSVolumeInfo
        : Option[List[zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly]] = scala
      .Option(impl.brokerEBSVolumeInfo())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kafka.model.BrokerEBSVolumeInfo.wrap(item)
        }.toList
      )
    override val configurationInfo
        : Option[zio.aws.kafka.model.ConfigurationInfo.ReadOnly] = scala
      .Option(impl.configurationInfo())
      .map(value => zio.aws.kafka.model.ConfigurationInfo.wrap(value))
    override val numberOfBrokerNodes: Option[__integer] =
      scala.Option(impl.numberOfBrokerNodes()).map(value => value: __integer)
    override val enhancedMonitoring
        : Option[zio.aws.kafka.model.EnhancedMonitoring] = scala
      .Option(impl.enhancedMonitoring())
      .map(value => zio.aws.kafka.model.EnhancedMonitoring.wrap(value))
    override val openMonitoring
        : Option[zio.aws.kafka.model.OpenMonitoring.ReadOnly] = scala
      .Option(impl.openMonitoring())
      .map(value => zio.aws.kafka.model.OpenMonitoring.wrap(value))
    override val kafkaVersion: Option[__string] =
      scala.Option(impl.kafkaVersion()).map(value => value: __string)
    override val loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      scala
        .Option(impl.loggingInfo())
        .map(value => zio.aws.kafka.model.LoggingInfo.wrap(value))
    override val instanceType: Option[__stringMin5Max32] =
      scala.Option(impl.instanceType()).map(value => value: __stringMin5Max32)
    override val clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly] = scala
      .Option(impl.clientAuthentication())
      .map(value => zio.aws.kafka.model.ClientAuthentication.wrap(value))
    override val encryptionInfo
        : Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly] = scala
      .Option(impl.encryptionInfo())
      .map(value => zio.aws.kafka.model.EncryptionInfo.wrap(value))
    override val connectivityInfo
        : Option[zio.aws.kafka.model.ConnectivityInfo.ReadOnly] = scala
      .Option(impl.connectivityInfo())
      .map(value => zio.aws.kafka.model.ConnectivityInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.MutableClusterInfo
  ): zio.aws.kafka.model.MutableClusterInfo.ReadOnly = new Wrapper(impl)
}
