package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateSecurityRequest(
    clientAuthentication: Option[zio.aws.kafka.model.ClientAuthentication] =
      None,
    clusterArn: __string,
    currentVersion: __string,
    encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateSecurityRequest = {
    import UpdateSecurityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateSecurityRequest
      .builder()
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .clusterArn(clusterArn: java.lang.String)
      .currentVersion(currentVersion: java.lang.String)
      .optionallyWith(encryptionInfo.map(value => value.buildAwsValue()))(
        _.encryptionInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateSecurityRequest.ReadOnly =
    zio.aws.kafka.model.UpdateSecurityRequest.wrap(buildAwsValue())
}
object UpdateSecurityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateSecurityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateSecurityRequest =
      zio.aws.kafka.model.UpdateSecurityRequest(
        clientAuthentication.map(value => value.asEditable),
        clusterArn,
        currentVersion,
        encryptionInfo.map(value => value.asEditable)
      )
    def clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly]
    def clusterArn: __string
    def currentVersion: __string
    def encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly]
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getCurrentVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(currentVersion)
    def getEncryptionInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      AwsError.unwrapOptionField("encryptionInfo", encryptionInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateSecurityRequest
  ) extends zio.aws.kafka.model.UpdateSecurityRequest.ReadOnly {
    override val clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly] = scala
      .Option(impl.clientAuthentication())
      .map(value => zio.aws.kafka.model.ClientAuthentication.wrap(value))
    override val clusterArn: __string = impl.clusterArn(): __string
    override val currentVersion: __string = impl.currentVersion(): __string
    override val encryptionInfo
        : Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly] = scala
      .Option(impl.encryptionInfo())
      .map(value => zio.aws.kafka.model.EncryptionInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateSecurityRequest
  ): zio.aws.kafka.model.UpdateSecurityRequest.ReadOnly = new Wrapper(impl)
}
