package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__long, __string, __timestampIso8601}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ConfigurationRevision(
    creationTime: __timestampIso8601,
    description: Option[__string] = None,
    revision: __long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ConfigurationRevision = {
    import ConfigurationRevision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ConfigurationRevision
      .builder()
      .creationTime(creationTime: Instant)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .revision(revision: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ConfigurationRevision.ReadOnly =
    zio.aws.kafka.model.ConfigurationRevision.wrap(buildAwsValue())
}
object ConfigurationRevision {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ConfigurationRevision
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ConfigurationRevision =
      zio.aws.kafka.model.ConfigurationRevision(
        creationTime,
        description.map(value => value),
        revision
      )
    def creationTime: __timestampIso8601
    def description: Option[__string]
    def revision: __long
    def getCreationTime: ZIO[Any, Nothing, __timestampIso8601] =
      ZIO.succeed(creationTime)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getRevision: ZIO[Any, Nothing, __long] = ZIO.succeed(revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ConfigurationRevision
  ) extends zio.aws.kafka.model.ConfigurationRevision.ReadOnly {
    override val creationTime: __timestampIso8601 =
      impl.creationTime(): __timestampIso8601
    override val description: Option[__string] =
      scala.Option(impl.description()).map(value => value: __string)
    override val revision: __long = impl.revision(): __long
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ConfigurationRevision
  ): zio.aws.kafka.model.ConfigurationRevision.ReadOnly = new Wrapper(impl)
}
