package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateBrokerStorageResponse(
    clusterArn: Option[__string] = None,
    clusterOperationArn: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageResponse = {
    import UpdateBrokerStorageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageResponse
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(
        clusterOperationArn.map(value => value: java.lang.String)
      )(_.clusterOperationArn)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateBrokerStorageResponse.ReadOnly =
    zio.aws.kafka.model.UpdateBrokerStorageResponse.wrap(buildAwsValue())
}
object UpdateBrokerStorageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateBrokerStorageResponse =
      zio.aws.kafka.model.UpdateBrokerStorageResponse(
        clusterArn.map(value => value),
        clusterOperationArn.map(value => value)
      )
    def clusterArn: Option[__string]
    def clusterOperationArn: Option[__string]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterOperationArn", clusterOperationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageResponse
  ) extends zio.aws.kafka.model.UpdateBrokerStorageResponse.ReadOnly {
    override val clusterArn: Option[__string] =
      scala.Option(impl.clusterArn()).map(value => value: __string)
    override val clusterOperationArn: Option[__string] =
      scala.Option(impl.clusterOperationArn()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageResponse
  ): zio.aws.kafka.model.UpdateBrokerStorageResponse.ReadOnly = new Wrapper(
    impl
  )
}
