package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StateInfo(
    code: Option[__string] = None,
    message: Option[__string] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.StateInfo = {
    import StateInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.StateInfo
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.StateInfo.ReadOnly =
    zio.aws.kafka.model.StateInfo.wrap(buildAwsValue())
}
object StateInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.StateInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.StateInfo = zio.aws.kafka.model
      .StateInfo(code.map(value => value), message.map(value => value))
    def code: Option[__string]
    def message: Option[__string]
    def getCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.StateInfo
  ) extends zio.aws.kafka.model.StateInfo.ReadOnly {
    override val code: Option[__string] =
      scala.Option(impl.code()).map(value => value: __string)
    override val message: Option[__string] =
      scala.Option(impl.message()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.StateInfo
  ): zio.aws.kafka.model.StateInfo.ReadOnly = new Wrapper(impl)
}
