package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateBrokerStorageRequest(
    clusterArn: __string,
    currentVersion: __string,
    targetBrokerEBSVolumeInfo: Iterable[zio.aws.kafka.model.BrokerEBSVolumeInfo]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageRequest = {
    import UpdateBrokerStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageRequest
      .builder()
      .clusterArn(__string.unwrap(clusterArn): java.lang.String)
      .currentVersion(__string.unwrap(currentVersion): java.lang.String)
      .targetBrokerEBSVolumeInfo(targetBrokerEBSVolumeInfo.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateBrokerStorageRequest.ReadOnly =
    zio.aws.kafka.model.UpdateBrokerStorageRequest.wrap(buildAwsValue())
}
object UpdateBrokerStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateBrokerStorageRequest =
      zio.aws.kafka.model.UpdateBrokerStorageRequest(
        clusterArn,
        currentVersion,
        targetBrokerEBSVolumeInfo.map { item =>
          item.asEditable
        }
      )
    def clusterArn: __string
    def currentVersion: __string
    def targetBrokerEBSVolumeInfo
        : List[zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly]
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getCurrentVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(currentVersion)
    def getTargetBrokerEBSVolumeInfo: ZIO[Any, Nothing, List[
      zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly
    ]] = ZIO.succeed(targetBrokerEBSVolumeInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageRequest
  ) extends zio.aws.kafka.model.UpdateBrokerStorageRequest.ReadOnly {
    override val clusterArn: __string =
      zio.aws.kafka.model.primitives.__string(impl.clusterArn())
    override val currentVersion: __string =
      zio.aws.kafka.model.primitives.__string(impl.currentVersion())
    override val targetBrokerEBSVolumeInfo
        : List[zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly] = impl
      .targetBrokerEBSVolumeInfo()
      .asScala
      .map { item =>
        zio.aws.kafka.model.BrokerEBSVolumeInfo.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageRequest
  ): zio.aws.kafka.model.UpdateBrokerStorageRequest.ReadOnly = new Wrapper(impl)
}
