package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{__integer, __boolean}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ProvisionedThroughput(
    enabled: Option[__boolean] = None,
    volumeThroughput: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ProvisionedThroughput = {
    import ProvisionedThroughput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ProvisionedThroughput
      .builder()
      .optionallyWith(
        enabled.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        volumeThroughput.map(value => __integer.unwrap(value): Integer)
      )(_.volumeThroughput)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ProvisionedThroughput.ReadOnly =
    zio.aws.kafka.model.ProvisionedThroughput.wrap(buildAwsValue())
}
object ProvisionedThroughput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ProvisionedThroughput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ProvisionedThroughput =
      zio.aws.kafka.model.ProvisionedThroughput(
        enabled.map(value => value),
        volumeThroughput.map(value => value)
      )
    def enabled: Option[__boolean]
    def volumeThroughput: Option[__integer]
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getVolumeThroughput: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("volumeThroughput", volumeThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ProvisionedThroughput
  ) extends zio.aws.kafka.model.ProvisionedThroughput.ReadOnly {
    override val enabled: Option[__boolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.kafka.model.primitives.__boolean(value))
    override val volumeThroughput: Option[__integer] = scala
      .Option(impl.volumeThroughput())
      .map(value => zio.aws.kafka.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ProvisionedThroughput
  ): zio.aws.kafka.model.ProvisionedThroughput.ReadOnly = new Wrapper(impl)
}
