package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NodeInfo(
    addedToClusterTime: Option[__string] = None,
    brokerNodeInfo: Option[zio.aws.kafka.model.BrokerNodeInfo] = None,
    instanceType: Option[__string] = None,
    nodeARN: Option[__string] = None,
    nodeType: Option[zio.aws.kafka.model.NodeType] = None,
    zookeeperNodeInfo: Option[zio.aws.kafka.model.ZookeeperNodeInfo] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.NodeInfo = {
    import NodeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.NodeInfo
      .builder()
      .optionallyWith(
        addedToClusterTime.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.addedToClusterTime)
      .optionallyWith(brokerNodeInfo.map(value => value.buildAwsValue()))(
        _.brokerNodeInfo
      )
      .optionallyWith(
        instanceType.map(value => __string.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        nodeARN.map(value => __string.unwrap(value): java.lang.String)
      )(_.nodeARN)
      .optionallyWith(nodeType.map(value => value.unwrap))(_.nodeType)
      .optionallyWith(zookeeperNodeInfo.map(value => value.buildAwsValue()))(
        _.zookeeperNodeInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.NodeInfo.ReadOnly =
    zio.aws.kafka.model.NodeInfo.wrap(buildAwsValue())
}
object NodeInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.NodeInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.NodeInfo = zio.aws.kafka.model.NodeInfo(
      addedToClusterTime.map(value => value),
      brokerNodeInfo.map(value => value.asEditable),
      instanceType.map(value => value),
      nodeARN.map(value => value),
      nodeType.map(value => value),
      zookeeperNodeInfo.map(value => value.asEditable)
    )
    def addedToClusterTime: Option[__string]
    def brokerNodeInfo: Option[zio.aws.kafka.model.BrokerNodeInfo.ReadOnly]
    def instanceType: Option[__string]
    def nodeARN: Option[__string]
    def nodeType: Option[zio.aws.kafka.model.NodeType]
    def zookeeperNodeInfo
        : Option[zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly]
    def getAddedToClusterTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("addedToClusterTime", addedToClusterTime)
    def getBrokerNodeInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.BrokerNodeInfo.ReadOnly] =
      AwsError.unwrapOptionField("brokerNodeInfo", brokerNodeInfo)
    def getInstanceType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getNodeARN: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nodeARN", nodeARN)
    def getNodeType: ZIO[Any, AwsError, zio.aws.kafka.model.NodeType] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getZookeeperNodeInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly] =
      AwsError.unwrapOptionField("zookeeperNodeInfo", zookeeperNodeInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.NodeInfo
  ) extends zio.aws.kafka.model.NodeInfo.ReadOnly {
    override val addedToClusterTime: Option[__string] = scala
      .Option(impl.addedToClusterTime())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val brokerNodeInfo
        : Option[zio.aws.kafka.model.BrokerNodeInfo.ReadOnly] = scala
      .Option(impl.brokerNodeInfo())
      .map(value => zio.aws.kafka.model.BrokerNodeInfo.wrap(value))
    override val instanceType: Option[__string] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val nodeARN: Option[__string] = scala
      .Option(impl.nodeARN())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val nodeType: Option[zio.aws.kafka.model.NodeType] = scala
      .Option(impl.nodeType())
      .map(value => zio.aws.kafka.model.NodeType.wrap(value))
    override val zookeeperNodeInfo
        : Option[zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly] = scala
      .Option(impl.zookeeperNodeInfo())
      .map(value => zio.aws.kafka.model.ZookeeperNodeInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.NodeInfo
  ): zio.aws.kafka.model.NodeInfo.ReadOnly = new Wrapper(impl)
}
