package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3(
    bucket: Option[__string] = None,
    enabled: __boolean,
    prefix: Option[__string] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.S3 = {
    import S3.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.S3
      .builder()
      .optionallyWith(
        bucket.map(value => __string.unwrap(value): java.lang.String)
      )(_.bucket)
      .enabled(__boolean.unwrap(enabled): java.lang.Boolean)
      .optionallyWith(
        prefix.map(value => __string.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.S3.ReadOnly =
    zio.aws.kafka.model.S3.wrap(buildAwsValue())
}
object S3 {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.S3] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.S3 = zio.aws.kafka.model
      .S3(bucket.map(value => value), enabled, prefix.map(value => value))
    def bucket: Option[__string]
    def enabled: __boolean
    def prefix: Option[__string]
    def getBucket: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getEnabled: ZIO[Any, Nothing, __boolean] = ZIO.succeed(enabled)
    def getPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.S3
  ) extends zio.aws.kafka.model.S3.ReadOnly {
    override val bucket: Option[__string] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val enabled: __boolean =
      zio.aws.kafka.model.primitives.__boolean(impl.enabled())
    override val prefix: Option[__string] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.S3
  ): zio.aws.kafka.model.S3.ReadOnly = new Wrapper(impl)
}
