package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBootstrapBrokersResponse(
    bootstrapBrokerString: Option[__string] = None,
    bootstrapBrokerStringTls: Option[__string] = None,
    bootstrapBrokerStringSaslScram: Option[__string] = None,
    bootstrapBrokerStringSaslIam: Option[__string] = None,
    bootstrapBrokerStringPublicTls: Option[__string] = None,
    bootstrapBrokerStringPublicSaslScram: Option[__string] = None,
    bootstrapBrokerStringPublicSaslIam: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse = {
    import GetBootstrapBrokersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse
      .builder()
      .optionallyWith(
        bootstrapBrokerString.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.bootstrapBrokerString)
      .optionallyWith(
        bootstrapBrokerStringTls.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.bootstrapBrokerStringTls)
      .optionallyWith(
        bootstrapBrokerStringSaslScram.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.bootstrapBrokerStringSaslScram)
      .optionallyWith(
        bootstrapBrokerStringSaslIam.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.bootstrapBrokerStringSaslIam)
      .optionallyWith(
        bootstrapBrokerStringPublicTls.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.bootstrapBrokerStringPublicTls)
      .optionallyWith(
        bootstrapBrokerStringPublicSaslScram.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.bootstrapBrokerStringPublicSaslScram)
      .optionallyWith(
        bootstrapBrokerStringPublicSaslIam.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.bootstrapBrokerStringPublicSaslIam)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.GetBootstrapBrokersResponse.ReadOnly =
    zio.aws.kafka.model.GetBootstrapBrokersResponse.wrap(buildAwsValue())
}
object GetBootstrapBrokersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.GetBootstrapBrokersResponse =
      zio.aws.kafka.model.GetBootstrapBrokersResponse(
        bootstrapBrokerString.map(value => value),
        bootstrapBrokerStringTls.map(value => value),
        bootstrapBrokerStringSaslScram.map(value => value),
        bootstrapBrokerStringSaslIam.map(value => value),
        bootstrapBrokerStringPublicTls.map(value => value),
        bootstrapBrokerStringPublicSaslScram.map(value => value),
        bootstrapBrokerStringPublicSaslIam.map(value => value)
      )
    def bootstrapBrokerString: Option[__string]
    def bootstrapBrokerStringTls: Option[__string]
    def bootstrapBrokerStringSaslScram: Option[__string]
    def bootstrapBrokerStringSaslIam: Option[__string]
    def bootstrapBrokerStringPublicTls: Option[__string]
    def bootstrapBrokerStringPublicSaslScram: Option[__string]
    def bootstrapBrokerStringPublicSaslIam: Option[__string]
    def getBootstrapBrokerString: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bootstrapBrokerString", bootstrapBrokerString)
    def getBootstrapBrokerStringTls: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("bootstrapBrokerStringTls", bootstrapBrokerStringTls)
    def getBootstrapBrokerStringSaslScram: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "bootstrapBrokerStringSaslScram",
        bootstrapBrokerStringSaslScram
      )
    def getBootstrapBrokerStringSaslIam: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "bootstrapBrokerStringSaslIam",
        bootstrapBrokerStringSaslIam
      )
    def getBootstrapBrokerStringPublicTls: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "bootstrapBrokerStringPublicTls",
        bootstrapBrokerStringPublicTls
      )
    def getBootstrapBrokerStringPublicSaslScram: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "bootstrapBrokerStringPublicSaslScram",
        bootstrapBrokerStringPublicSaslScram
      )
    def getBootstrapBrokerStringPublicSaslIam: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "bootstrapBrokerStringPublicSaslIam",
        bootstrapBrokerStringPublicSaslIam
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse
  ) extends zio.aws.kafka.model.GetBootstrapBrokersResponse.ReadOnly {
    override val bootstrapBrokerString: Option[__string] = scala
      .Option(impl.bootstrapBrokerString())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val bootstrapBrokerStringTls: Option[__string] = scala
      .Option(impl.bootstrapBrokerStringTls())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val bootstrapBrokerStringSaslScram: Option[__string] = scala
      .Option(impl.bootstrapBrokerStringSaslScram())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val bootstrapBrokerStringSaslIam: Option[__string] = scala
      .Option(impl.bootstrapBrokerStringSaslIam())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val bootstrapBrokerStringPublicTls: Option[__string] = scala
      .Option(impl.bootstrapBrokerStringPublicTls())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val bootstrapBrokerStringPublicSaslScram: Option[__string] = scala
      .Option(impl.bootstrapBrokerStringPublicSaslScram())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val bootstrapBrokerStringPublicSaslIam: Option[__string] = scala
      .Option(impl.bootstrapBrokerStringPublicSaslIam())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse
  ): zio.aws.kafka.model.GetBootstrapBrokersResponse.ReadOnly = new Wrapper(
    impl
  )
}
