package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__string, __stringMin1Max64}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateClusterV2Request(
    clusterName: __stringMin1Max64,
    tags: Option[Map[__string, __string]] = None,
    provisioned: Option[zio.aws.kafka.model.ProvisionedRequest] = None,
    serverless: Option[zio.aws.kafka.model.ServerlessRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateClusterV2Request = {
    import CreateClusterV2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateClusterV2Request
      .builder()
      .clusterName(__stringMin1Max64.unwrap(clusterName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(provisioned.map(value => value.buildAwsValue()))(
        _.provisioned
      )
      .optionallyWith(serverless.map(value => value.buildAwsValue()))(
        _.serverless
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateClusterV2Request.ReadOnly =
    zio.aws.kafka.model.CreateClusterV2Request.wrap(buildAwsValue())
}
object CreateClusterV2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateClusterV2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateClusterV2Request =
      zio.aws.kafka.model.CreateClusterV2Request(
        clusterName,
        tags.map(value => value),
        provisioned.map(value => value.asEditable),
        serverless.map(value => value.asEditable)
      )
    def clusterName: __stringMin1Max64
    def tags: Option[Map[__string, __string]]
    def provisioned: Option[zio.aws.kafka.model.ProvisionedRequest.ReadOnly]
    def serverless: Option[zio.aws.kafka.model.ServerlessRequest.ReadOnly]
    def getClusterName: ZIO[Any, Nothing, __stringMin1Max64] =
      ZIO.succeed(clusterName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProvisioned
        : ZIO[Any, AwsError, zio.aws.kafka.model.ProvisionedRequest.ReadOnly] =
      AwsError.unwrapOptionField("provisioned", provisioned)
    def getServerless
        : ZIO[Any, AwsError, zio.aws.kafka.model.ServerlessRequest.ReadOnly] =
      AwsError.unwrapOptionField("serverless", serverless)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterV2Request
  ) extends zio.aws.kafka.model.CreateClusterV2Request.ReadOnly {
    override val clusterName: __stringMin1Max64 =
      zio.aws.kafka.model.primitives.__stringMin1Max64(impl.clusterName())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.kafka.model.primitives
              .__string(key) -> zio.aws.kafka.model.primitives.__string(value)
          })
          .toMap
      )
    override val provisioned
        : Option[zio.aws.kafka.model.ProvisionedRequest.ReadOnly] = scala
      .Option(impl.provisioned())
      .map(value => zio.aws.kafka.model.ProvisionedRequest.wrap(value))
    override val serverless
        : Option[zio.aws.kafka.model.ServerlessRequest.ReadOnly] = scala
      .Option(impl.serverless())
      .map(value => zio.aws.kafka.model.ServerlessRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterV2Request
  ): zio.aws.kafka.model.CreateClusterV2Request.ReadOnly = new Wrapper(impl)
}
