package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__blob, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationRequest(
    arn: __string,
    description: Option[__string] = None,
    serverProperties: __blob
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateConfigurationRequest = {
    import UpdateConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateConfigurationRequest
      .builder()
      .arn(__string.unwrap(arn): java.lang.String)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .serverProperties(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(serverProperties.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateConfigurationRequest.ReadOnly =
    zio.aws.kafka.model.UpdateConfigurationRequest.wrap(buildAwsValue())
}
object UpdateConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateConfigurationRequest =
      zio.aws.kafka.model.UpdateConfigurationRequest(
        arn,
        description.map(value => value),
        serverProperties
      )
    def arn: __string
    def description: Option[__string]
    def serverProperties: __blob
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getServerProperties: ZIO[Any, Nothing, __blob] =
      ZIO.succeed(serverProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateConfigurationRequest
  ) extends zio.aws.kafka.model.UpdateConfigurationRequest.ReadOnly {
    override val arn: __string =
      zio.aws.kafka.model.primitives.__string(impl.arn())
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val serverProperties: __blob = zio.aws.kafka.model.primitives
      .__blob(zio.Chunk.fromArray(impl.serverProperties().asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateConfigurationRequest
  ): zio.aws.kafka.model.UpdateConfigurationRequest.ReadOnly = new Wrapper(impl)
}
