package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateBrokerTypeResponse(
    clusterArn: Option[__string] = None,
    clusterOperationArn: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse = {
    import UpdateBrokerTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse
      .builder()
      .optionallyWith(
        clusterArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        clusterOperationArn.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.clusterOperationArn)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateBrokerTypeResponse.ReadOnly =
    zio.aws.kafka.model.UpdateBrokerTypeResponse.wrap(buildAwsValue())
}
object UpdateBrokerTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateBrokerTypeResponse =
      zio.aws.kafka.model.UpdateBrokerTypeResponse(
        clusterArn.map(value => value),
        clusterOperationArn.map(value => value)
      )
    def clusterArn: Option[__string]
    def clusterOperationArn: Option[__string]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterOperationArn", clusterOperationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse
  ) extends zio.aws.kafka.model.UpdateBrokerTypeResponse.ReadOnly {
    override val clusterArn: Option[__string] = scala
      .Option(impl.clusterArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val clusterOperationArn: Option[__string] = scala
      .Option(impl.clusterOperationArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse
  ): zio.aws.kafka.model.UpdateBrokerTypeResponse.ReadOnly = new Wrapper(impl)
}
