package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Prometheus(
    jmxExporter: Option[zio.aws.kafka.model.JmxExporter] = None,
    nodeExporter: Option[zio.aws.kafka.model.NodeExporter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.Prometheus = {
    import Prometheus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Prometheus
      .builder()
      .optionallyWith(jmxExporter.map(value => value.buildAwsValue()))(
        _.jmxExporter
      )
      .optionallyWith(nodeExporter.map(value => value.buildAwsValue()))(
        _.nodeExporter
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Prometheus.ReadOnly =
    zio.aws.kafka.model.Prometheus.wrap(buildAwsValue())
}
object Prometheus {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.Prometheus] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Prometheus =
      zio.aws.kafka.model.Prometheus(
        jmxExporter.map(value => value.asEditable),
        nodeExporter.map(value => value.asEditable)
      )
    def jmxExporter: Option[zio.aws.kafka.model.JmxExporter.ReadOnly]
    def nodeExporter: Option[zio.aws.kafka.model.NodeExporter.ReadOnly]
    def getJmxExporter
        : ZIO[Any, AwsError, zio.aws.kafka.model.JmxExporter.ReadOnly] =
      AwsError.unwrapOptionField("jmxExporter", jmxExporter)
    def getNodeExporter
        : ZIO[Any, AwsError, zio.aws.kafka.model.NodeExporter.ReadOnly] =
      AwsError.unwrapOptionField("nodeExporter", nodeExporter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Prometheus
  ) extends zio.aws.kafka.model.Prometheus.ReadOnly {
    override val jmxExporter: Option[zio.aws.kafka.model.JmxExporter.ReadOnly] =
      scala
        .Option(impl.jmxExporter())
        .map(value => zio.aws.kafka.model.JmxExporter.wrap(value))
    override val nodeExporter
        : Option[zio.aws.kafka.model.NodeExporter.ReadOnly] = scala
      .Option(impl.nodeExporter())
      .map(value => zio.aws.kafka.model.NodeExporter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Prometheus
  ): zio.aws.kafka.model.Prometheus.ReadOnly = new Wrapper(impl)
}
