package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCompatibleKafkaVersionsRequest(
    clusterArn: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest = {
    import GetCompatibleKafkaVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest
      .builder()
      .optionallyWith(
        clusterArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest.ReadOnly =
    zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest.wrap(buildAwsValue())
}
object GetCompatibleKafkaVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest =
      zio.aws.kafka.model
        .GetCompatibleKafkaVersionsRequest(clusterArn.map(value => value))
    def clusterArn: Option[__string]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest
  ) extends zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest.ReadOnly {
    override val clusterArn: Option[__string] = scala
      .Option(impl.clusterArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest
  ): zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
