package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EncryptionAtRest(dataVolumeKMSKeyId: __string) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.EncryptionAtRest = {
    import EncryptionAtRest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.EncryptionAtRest
      .builder()
      .dataVolumeKMSKeyId(__string.unwrap(dataVolumeKMSKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.EncryptionAtRest.ReadOnly =
    zio.aws.kafka.model.EncryptionAtRest.wrap(buildAwsValue())
}
object EncryptionAtRest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.EncryptionAtRest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.EncryptionAtRest =
      zio.aws.kafka.model.EncryptionAtRest(dataVolumeKMSKeyId)
    def dataVolumeKMSKeyId: __string
    def getDataVolumeKMSKeyId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(dataVolumeKMSKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.EncryptionAtRest
  ) extends zio.aws.kafka.model.EncryptionAtRest.ReadOnly {
    override val dataVolumeKMSKeyId: __string =
      zio.aws.kafka.model.primitives.__string(impl.dataVolumeKMSKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.EncryptionAtRest
  ): zio.aws.kafka.model.EncryptionAtRest.ReadOnly = new Wrapper(impl)
}
