package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{
  __blob,
  __long,
  __timestampIso8601,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationRevisionResponse(
    arn: Option[__string] = None,
    creationTime: Option[__timestampIso8601] = None,
    description: Option[__string] = None,
    revision: Option[__long] = None,
    serverProperties: Option[__blob] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse = {
    import DescribeConfigurationRevisionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationTime.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        revision.map(value => __long.unwrap(value): java.lang.Long)
      )(_.revision)
      .optionallyWith(
        serverProperties.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.serverProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.DescribeConfigurationRevisionResponse.ReadOnly =
    zio.aws.kafka.model.DescribeConfigurationRevisionResponse
      .wrap(buildAwsValue())
}
object DescribeConfigurationRevisionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DescribeConfigurationRevisionResponse =
      zio.aws.kafka.model.DescribeConfigurationRevisionResponse(
        arn.map(value => value),
        creationTime.map(value => value),
        description.map(value => value),
        revision.map(value => value),
        serverProperties.map(value => value)
      )
    def arn: Option[__string]
    def creationTime: Option[__timestampIso8601]
    def description: Option[__string]
    def revision: Option[__long]
    def serverProperties: Option[__blob]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getRevision: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("revision", revision)
    def getServerProperties: ZIO[Any, AwsError, __blob] =
      AwsError.unwrapOptionField("serverProperties", serverProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse
  ) extends zio.aws.kafka.model.DescribeConfigurationRevisionResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val creationTime: Option[__timestampIso8601] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.kafka.model.primitives.__timestampIso8601(value))
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val revision: Option[__long] = scala
      .Option(impl.revision())
      .map(value => zio.aws.kafka.model.primitives.__long(value))
    override val serverProperties: Option[__blob] = scala
      .Option(impl.serverProperties())
      .map(value =>
        zio.aws.kafka.model.primitives
          .__blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse
  ): zio.aws.kafka.model.DescribeConfigurationRevisionResponse.ReadOnly =
    new Wrapper(impl)
}
