package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateConfigurationResponse(
    arn: Option[__string] = None,
    creationTime: Option[__timestampIso8601] = None,
    latestRevision: Option[zio.aws.kafka.model.ConfigurationRevision] = None,
    name: Option[__string] = None,
    state: Option[zio.aws.kafka.model.ConfigurationState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse = {
    import CreateConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationTime.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(latestRevision.map(value => value.buildAwsValue()))(
        _.latestRevision
      )
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateConfigurationResponse.ReadOnly =
    zio.aws.kafka.model.CreateConfigurationResponse.wrap(buildAwsValue())
}
object CreateConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateConfigurationResponse =
      zio.aws.kafka.model.CreateConfigurationResponse(
        arn.map(value => value),
        creationTime.map(value => value),
        latestRevision.map(value => value.asEditable),
        name.map(value => value),
        state.map(value => value)
      )
    def arn: Option[__string]
    def creationTime: Option[__timestampIso8601]
    def latestRevision
        : Option[zio.aws.kafka.model.ConfigurationRevision.ReadOnly]
    def name: Option[__string]
    def state: Option[zio.aws.kafka.model.ConfigurationState]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLatestRevision: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ConfigurationRevision.ReadOnly
    ] = AwsError.unwrapOptionField("latestRevision", latestRevision)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ConfigurationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse
  ) extends zio.aws.kafka.model.CreateConfigurationResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val creationTime: Option[__timestampIso8601] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.kafka.model.primitives.__timestampIso8601(value))
    override val latestRevision
        : Option[zio.aws.kafka.model.ConfigurationRevision.ReadOnly] = scala
      .Option(impl.latestRevision())
      .map(value => zio.aws.kafka.model.ConfigurationRevision.wrap(value))
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val state: Option[zio.aws.kafka.model.ConfigurationState] = scala
      .Option(impl.state())
      .map(value => zio.aws.kafka.model.ConfigurationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse
  ): zio.aws.kafka.model.CreateConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
