package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__long, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BrokerSoftwareInfo(
    configurationArn: Option[__string] = None,
    configurationRevision: Option[__long] = None,
    kafkaVersion: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo = {
    import BrokerSoftwareInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo
      .builder()
      .optionallyWith(
        configurationArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.configurationArn)
      .optionallyWith(
        configurationRevision.map(value => __long.unwrap(value): java.lang.Long)
      )(_.configurationRevision)
      .optionallyWith(
        kafkaVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.kafkaVersion)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly =
    zio.aws.kafka.model.BrokerSoftwareInfo.wrap(buildAwsValue())
}
object BrokerSoftwareInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BrokerSoftwareInfo =
      zio.aws.kafka.model.BrokerSoftwareInfo(
        configurationArn.map(value => value),
        configurationRevision.map(value => value),
        kafkaVersion.map(value => value)
      )
    def configurationArn: Option[__string]
    def configurationRevision: Option[__long]
    def kafkaVersion: Option[__string]
    def getConfigurationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("configurationArn", configurationArn)
    def getConfigurationRevision: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("configurationRevision", configurationRevision)
    def getKafkaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("kafkaVersion", kafkaVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo
  ) extends zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly {
    override val configurationArn: Option[__string] = scala
      .Option(impl.configurationArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val configurationRevision: Option[__long] = scala
      .Option(impl.configurationRevision())
      .map(value => zio.aws.kafka.model.primitives.__long(value))
    override val kafkaVersion: Option[__string] = scala
      .Option(impl.kafkaVersion())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo
  ): zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly = new Wrapper(impl)
}
