package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BrokerLogs(
    cloudWatchLogs: Option[zio.aws.kafka.model.CloudWatchLogs] = None,
    firehose: Option[zio.aws.kafka.model.Firehose] = None,
    s3: Option[zio.aws.kafka.model.S3] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BrokerLogs = {
    import BrokerLogs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BrokerLogs
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(firehose.map(value => value.buildAwsValue()))(_.firehose)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.BrokerLogs.ReadOnly =
    zio.aws.kafka.model.BrokerLogs.wrap(buildAwsValue())
}
object BrokerLogs {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.BrokerLogs] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BrokerLogs =
      zio.aws.kafka.model.BrokerLogs(
        cloudWatchLogs.map(value => value.asEditable),
        firehose.map(value => value.asEditable),
        s3.map(value => value.asEditable)
      )
    def cloudWatchLogs: Option[zio.aws.kafka.model.CloudWatchLogs.ReadOnly]
    def firehose: Option[zio.aws.kafka.model.Firehose.ReadOnly]
    def s3: Option[zio.aws.kafka.model.S3.ReadOnly]
    def getCloudWatchLogs
        : ZIO[Any, AwsError, zio.aws.kafka.model.CloudWatchLogs.ReadOnly] =
      AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getFirehose: ZIO[Any, AwsError, zio.aws.kafka.model.Firehose.ReadOnly] =
      AwsError.unwrapOptionField("firehose", firehose)
    def getS3: ZIO[Any, AwsError, zio.aws.kafka.model.S3.ReadOnly] =
      AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BrokerLogs
  ) extends zio.aws.kafka.model.BrokerLogs.ReadOnly {
    override val cloudWatchLogs
        : Option[zio.aws.kafka.model.CloudWatchLogs.ReadOnly] = scala
      .Option(impl.cloudWatchLogs())
      .map(value => zio.aws.kafka.model.CloudWatchLogs.wrap(value))
    override val firehose: Option[zio.aws.kafka.model.Firehose.ReadOnly] = scala
      .Option(impl.firehose())
      .map(value => zio.aws.kafka.model.Firehose.wrap(value))
    override val s3: Option[zio.aws.kafka.model.S3.ReadOnly] =
      scala.Option(impl.s3()).map(value => zio.aws.kafka.model.S3.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BrokerLogs
  ): zio.aws.kafka.model.BrokerLogs.ReadOnly = new Wrapper(impl)
}
