package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDisassociateScramSecretRequest(
    clusterArn: __string,
    secretArnList: Iterable[__string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretRequest = {
    import BatchDisassociateScramSecretRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretRequest
      .builder()
      .clusterArn(__string.unwrap(clusterArn): java.lang.String)
      .secretArnList(secretArnList.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.BatchDisassociateScramSecretRequest.ReadOnly =
    zio.aws.kafka.model.BatchDisassociateScramSecretRequest
      .wrap(buildAwsValue())
}
object BatchDisassociateScramSecretRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BatchDisassociateScramSecretRequest =
      zio.aws.kafka.model
        .BatchDisassociateScramSecretRequest(clusterArn, secretArnList)
    def clusterArn: __string
    def secretArnList: List[__string]
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getSecretArnList: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(secretArnList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretRequest
  ) extends zio.aws.kafka.model.BatchDisassociateScramSecretRequest.ReadOnly {
    override val clusterArn: __string =
      zio.aws.kafka.model.primitives.__string(impl.clusterArn())
    override val secretArnList: List[__string] = impl
      .secretArnList()
      .asScala
      .map { item =>
        zio.aws.kafka.model.primitives.__string(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretRequest
  ): zio.aws.kafka.model.BatchDisassociateScramSecretRequest.ReadOnly =
    new Wrapper(impl)
}
