package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchAssociateScramSecretRequest(
    clusterArn: __string,
    secretArnList: Iterable[__string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretRequest = {
    import BatchAssociateScramSecretRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretRequest
      .builder()
      .clusterArn(__string.unwrap(clusterArn): java.lang.String)
      .secretArnList(secretArnList.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.BatchAssociateScramSecretRequest.ReadOnly =
    zio.aws.kafka.model.BatchAssociateScramSecretRequest.wrap(buildAwsValue())
}
object BatchAssociateScramSecretRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BatchAssociateScramSecretRequest =
      zio.aws.kafka.model
        .BatchAssociateScramSecretRequest(clusterArn, secretArnList)
    def clusterArn: __string
    def secretArnList: List[__string]
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getSecretArnList: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(secretArnList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretRequest
  ) extends zio.aws.kafka.model.BatchAssociateScramSecretRequest.ReadOnly {
    override val clusterArn: __string =
      zio.aws.kafka.model.primitives.__string(impl.clusterArn())
    override val secretArnList: List[__string] = impl
      .secretArnList()
      .asScala
      .map { item =>
        zio.aws.kafka.model.primitives.__string(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretRequest
  ): zio.aws.kafka.model.BatchAssociateScramSecretRequest.ReadOnly =
    new Wrapper(impl)
}
