package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateClusterConfigurationRequest(
    clusterArn: __string,
    configurationInfo: zio.aws.kafka.model.ConfigurationInfo,
    currentVersion: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationRequest = {
    import UpdateClusterConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationRequest
      .builder()
      .clusterArn(__string.unwrap(clusterArn): java.lang.String)
      .configurationInfo(configurationInfo.buildAwsValue())
      .currentVersion(__string.unwrap(currentVersion): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.UpdateClusterConfigurationRequest.ReadOnly =
    zio.aws.kafka.model.UpdateClusterConfigurationRequest.wrap(buildAwsValue())
}
object UpdateClusterConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateClusterConfigurationRequest =
      zio.aws.kafka.model.UpdateClusterConfigurationRequest(
        clusterArn,
        configurationInfo.asEditable,
        currentVersion
      )
    def clusterArn: __string
    def configurationInfo: zio.aws.kafka.model.ConfigurationInfo.ReadOnly
    def currentVersion: __string
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getConfigurationInfo
        : ZIO[Any, Nothing, zio.aws.kafka.model.ConfigurationInfo.ReadOnly] =
      ZIO.succeed(configurationInfo)
    def getCurrentVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(currentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationRequest
  ) extends zio.aws.kafka.model.UpdateClusterConfigurationRequest.ReadOnly {
    override val clusterArn: __string =
      zio.aws.kafka.model.primitives.__string(impl.clusterArn())
    override val configurationInfo
        : zio.aws.kafka.model.ConfigurationInfo.ReadOnly =
      zio.aws.kafka.model.ConfigurationInfo.wrap(impl.configurationInfo())
    override val currentVersion: __string =
      zio.aws.kafka.model.primitives.__string(impl.currentVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationRequest
  ): zio.aws.kafka.model.UpdateClusterConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
