package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicationInfoDescription(
    consumerGroupReplication: Optional[
      zio.aws.kafka.model.ConsumerGroupReplication
    ] = Optional.Absent,
    sourceKafkaClusterAlias: Optional[__string] = Optional.Absent,
    targetCompressionType: Optional[zio.aws.kafka.model.TargetCompressionType] =
      Optional.Absent,
    targetKafkaClusterAlias: Optional[__string] = Optional.Absent,
    topicReplication: Optional[zio.aws.kafka.model.TopicReplication] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ReplicationInfoDescription = {
    import ReplicationInfoDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ReplicationInfoDescription
      .builder()
      .optionallyWith(
        consumerGroupReplication.map(value => value.buildAwsValue())
      )(_.consumerGroupReplication)
      .optionallyWith(
        sourceKafkaClusterAlias.map(value => value: java.lang.String)
      )(_.sourceKafkaClusterAlias)
      .optionallyWith(targetCompressionType.map(value => value.unwrap))(
        _.targetCompressionType
      )
      .optionallyWith(
        targetKafkaClusterAlias.map(value => value: java.lang.String)
      )(_.targetKafkaClusterAlias)
      .optionallyWith(topicReplication.map(value => value.buildAwsValue()))(
        _.topicReplication
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ReplicationInfoDescription.ReadOnly =
    zio.aws.kafka.model.ReplicationInfoDescription.wrap(buildAwsValue())
}
object ReplicationInfoDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ReplicationInfoDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ReplicationInfoDescription =
      zio.aws.kafka.model.ReplicationInfoDescription(
        consumerGroupReplication.map(value => value.asEditable),
        sourceKafkaClusterAlias.map(value => value),
        targetCompressionType.map(value => value),
        targetKafkaClusterAlias.map(value => value),
        topicReplication.map(value => value.asEditable)
      )
    def consumerGroupReplication
        : Optional[zio.aws.kafka.model.ConsumerGroupReplication.ReadOnly]
    def sourceKafkaClusterAlias: Optional[__string]
    def targetCompressionType
        : Optional[zio.aws.kafka.model.TargetCompressionType]
    def targetKafkaClusterAlias: Optional[__string]
    def topicReplication
        : Optional[zio.aws.kafka.model.TopicReplication.ReadOnly]
    def getConsumerGroupReplication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ConsumerGroupReplication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "consumerGroupReplication",
      consumerGroupReplication
    )
    def getSourceKafkaClusterAlias: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("sourceKafkaClusterAlias", sourceKafkaClusterAlias)
    def getTargetCompressionType
        : ZIO[Any, AwsError, zio.aws.kafka.model.TargetCompressionType] =
      AwsError.unwrapOptionField("targetCompressionType", targetCompressionType)
    def getTargetKafkaClusterAlias: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("targetKafkaClusterAlias", targetKafkaClusterAlias)
    def getTopicReplication
        : ZIO[Any, AwsError, zio.aws.kafka.model.TopicReplication.ReadOnly] =
      AwsError.unwrapOptionField("topicReplication", topicReplication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ReplicationInfoDescription
  ) extends zio.aws.kafka.model.ReplicationInfoDescription.ReadOnly {
    override val consumerGroupReplication
        : Optional[zio.aws.kafka.model.ConsumerGroupReplication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumerGroupReplication())
        .map(value => zio.aws.kafka.model.ConsumerGroupReplication.wrap(value))
    override val sourceKafkaClusterAlias: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceKafkaClusterAlias())
        .map(value => value: __string)
    override val targetCompressionType
        : Optional[zio.aws.kafka.model.TargetCompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetCompressionType())
        .map(value => zio.aws.kafka.model.TargetCompressionType.wrap(value))
    override val targetKafkaClusterAlias: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetKafkaClusterAlias())
        .map(value => value: __string)
    override val topicReplication
        : Optional[zio.aws.kafka.model.TopicReplication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicReplication())
        .map(value => zio.aws.kafka.model.TopicReplication.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ReplicationInfoDescription
  ): zio.aws.kafka.model.ReplicationInfoDescription.ReadOnly = new Wrapper(impl)
}
