package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ClusterOperationV2(
    clusterArn: Optional[__string] = Optional.Absent,
    clusterType: Optional[zio.aws.kafka.model.ClusterType] = Optional.Absent,
    startTime: Optional[__timestampIso8601] = Optional.Absent,
    endTime: Optional[__timestampIso8601] = Optional.Absent,
    errorInfo: Optional[zio.aws.kafka.model.ErrorInfo] = Optional.Absent,
    operationArn: Optional[__string] = Optional.Absent,
    operationState: Optional[__string] = Optional.Absent,
    operationType: Optional[__string] = Optional.Absent,
    provisioned: Optional[zio.aws.kafka.model.ClusterOperationV2Provisioned] =
      Optional.Absent,
    serverless: Optional[zio.aws.kafka.model.ClusterOperationV2Serverless] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClusterOperationV2 = {
    import ClusterOperationV2.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClusterOperationV2
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(clusterType.map(value => value.unwrap))(_.clusterType)
      .optionallyWith(startTime.map(value => value: Instant))(_.startTime)
      .optionallyWith(endTime.map(value => value: Instant))(_.endTime)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .optionallyWith(operationArn.map(value => value: java.lang.String))(
        _.operationArn
      )
      .optionallyWith(operationState.map(value => value: java.lang.String))(
        _.operationState
      )
      .optionallyWith(operationType.map(value => value: java.lang.String))(
        _.operationType
      )
      .optionallyWith(provisioned.map(value => value.buildAwsValue()))(
        _.provisioned
      )
      .optionallyWith(serverless.map(value => value.buildAwsValue()))(
        _.serverless
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClusterOperationV2.ReadOnly =
    zio.aws.kafka.model.ClusterOperationV2.wrap(buildAwsValue())
}
object ClusterOperationV2 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ClusterOperationV2
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClusterOperationV2 =
      zio.aws.kafka.model.ClusterOperationV2(
        clusterArn.map(value => value),
        clusterType.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        errorInfo.map(value => value.asEditable),
        operationArn.map(value => value),
        operationState.map(value => value),
        operationType.map(value => value),
        provisioned.map(value => value.asEditable),
        serverless.map(value => value.asEditable)
      )
    def clusterArn: Optional[__string]
    def clusterType: Optional[zio.aws.kafka.model.ClusterType]
    def startTime: Optional[__timestampIso8601]
    def endTime: Optional[__timestampIso8601]
    def errorInfo: Optional[zio.aws.kafka.model.ErrorInfo.ReadOnly]
    def operationArn: Optional[__string]
    def operationState: Optional[__string]
    def operationType: Optional[__string]
    def provisioned
        : Optional[zio.aws.kafka.model.ClusterOperationV2Provisioned.ReadOnly]
    def serverless
        : Optional[zio.aws.kafka.model.ClusterOperationV2Serverless.ReadOnly]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterType: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterType] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getStartTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getErrorInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ErrorInfo.ReadOnly] =
      AwsError.unwrapOptionField("errorInfo", errorInfo)
    def getOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationArn", operationArn)
    def getOperationState: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationState", operationState)
    def getOperationType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationType", operationType)
    def getProvisioned: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClusterOperationV2Provisioned.ReadOnly
    ] = AwsError.unwrapOptionField("provisioned", provisioned)
    def getServerless: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClusterOperationV2Serverless.ReadOnly
    ] = AwsError.unwrapOptionField("serverless", serverless)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationV2
  ) extends zio.aws.kafka.model.ClusterOperationV2.ReadOnly {
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val clusterType: Optional[zio.aws.kafka.model.ClusterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterType())
        .map(value => zio.aws.kafka.model.ClusterType.wrap(value))
    override val startTime: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: __timestampIso8601)
    override val endTime: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: __timestampIso8601)
    override val errorInfo: Optional[zio.aws.kafka.model.ErrorInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorInfo())
        .map(value => zio.aws.kafka.model.ErrorInfo.wrap(value))
    override val operationArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operationArn())
      .map(value => value: __string)
    override val operationState: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operationState())
      .map(value => value: __string)
    override val operationType: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operationType())
      .map(value => value: __string)
    override val provisioned
        : Optional[zio.aws.kafka.model.ClusterOperationV2Provisioned.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioned())
        .map(value =>
          zio.aws.kafka.model.ClusterOperationV2Provisioned.wrap(value)
        )
    override val serverless
        : Optional[zio.aws.kafka.model.ClusterOperationV2Serverless.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverless())
        .map(value =>
          zio.aws.kafka.model.ClusterOperationV2Serverless.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationV2
  ): zio.aws.kafka.model.ClusterOperationV2.ReadOnly = new Wrapper(impl)
}
