package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListClusterOperationsV2Response(
    clusterOperationInfoList: Optional[
      Iterable[zio.aws.kafka.model.ClusterOperationV2Summary]
    ] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response = {
    import ListClusterOperationsV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response
      .builder()
      .optionallyWith(
        clusterOperationInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterOperationInfoList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListClusterOperationsV2Response.ReadOnly =
    zio.aws.kafka.model.ListClusterOperationsV2Response.wrap(buildAwsValue())
}
object ListClusterOperationsV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClusterOperationsV2Response =
      zio.aws.kafka.model.ListClusterOperationsV2Response(
        clusterOperationInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clusterOperationInfoList
        : Optional[List[zio.aws.kafka.model.ClusterOperationV2Summary.ReadOnly]]
    def nextToken: Optional[__string]
    def getClusterOperationInfoList: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ClusterOperationV2Summary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "clusterOperationInfoList",
      clusterOperationInfoList
    )
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response
  ) extends zio.aws.kafka.model.ListClusterOperationsV2Response.ReadOnly {
    override val clusterOperationInfoList: Optional[
      List[zio.aws.kafka.model.ClusterOperationV2Summary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterOperationInfoList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kafka.model.ClusterOperationV2Summary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response
  ): zio.aws.kafka.model.ListClusterOperationsV2Response.ReadOnly = new Wrapper(
    impl
  )
}
