package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KafkaClusterSummary(
    amazonMskCluster: Optional[zio.aws.kafka.model.AmazonMskCluster] =
      Optional.Absent,
    kafkaClusterAlias: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.KafkaClusterSummary = {
    import KafkaClusterSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.KafkaClusterSummary
      .builder()
      .optionallyWith(amazonMskCluster.map(value => value.buildAwsValue()))(
        _.amazonMskCluster
      )
      .optionallyWith(kafkaClusterAlias.map(value => value: java.lang.String))(
        _.kafkaClusterAlias
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.KafkaClusterSummary.ReadOnly =
    zio.aws.kafka.model.KafkaClusterSummary.wrap(buildAwsValue())
}
object KafkaClusterSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.KafkaClusterSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.KafkaClusterSummary =
      zio.aws.kafka.model.KafkaClusterSummary(
        amazonMskCluster.map(value => value.asEditable),
        kafkaClusterAlias.map(value => value)
      )
    def amazonMskCluster
        : Optional[zio.aws.kafka.model.AmazonMskCluster.ReadOnly]
    def kafkaClusterAlias: Optional[__string]
    def getAmazonMskCluster
        : ZIO[Any, AwsError, zio.aws.kafka.model.AmazonMskCluster.ReadOnly] =
      AwsError.unwrapOptionField("amazonMskCluster", amazonMskCluster)
    def getKafkaClusterAlias: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("kafkaClusterAlias", kafkaClusterAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.KafkaClusterSummary
  ) extends zio.aws.kafka.model.KafkaClusterSummary.ReadOnly {
    override val amazonMskCluster
        : Optional[zio.aws.kafka.model.AmazonMskCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amazonMskCluster())
        .map(value => zio.aws.kafka.model.AmazonMskCluster.wrap(value))
    override val kafkaClusterAlias: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.kafkaClusterAlias())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.KafkaClusterSummary
  ): zio.aws.kafka.model.KafkaClusterSummary.ReadOnly = new Wrapper(impl)
}
