package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__stringMax249, __boolean}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TopicReplication(
    copyAccessControlListsForTopics: Optional[__boolean] = Optional.Absent,
    copyTopicConfigurations: Optional[__boolean] = Optional.Absent,
    detectAndCopyNewTopics: Optional[__boolean] = Optional.Absent,
    topicsToExclude: Optional[Iterable[__stringMax249]] = Optional.Absent,
    topicsToReplicate: Iterable[__stringMax249]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.TopicReplication = {
    import TopicReplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.TopicReplication
      .builder()
      .optionallyWith(
        copyAccessControlListsForTopics.map(value => value: java.lang.Boolean)
      )(_.copyAccessControlListsForTopics)
      .optionallyWith(
        copyTopicConfigurations.map(value => value: java.lang.Boolean)
      )(_.copyTopicConfigurations)
      .optionallyWith(
        detectAndCopyNewTopics.map(value => value: java.lang.Boolean)
      )(_.detectAndCopyNewTopics)
      .optionallyWith(
        topicsToExclude.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.topicsToExclude)
      .topicsToReplicate(topicsToReplicate.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.TopicReplication.ReadOnly =
    zio.aws.kafka.model.TopicReplication.wrap(buildAwsValue())
}
object TopicReplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.TopicReplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.TopicReplication =
      zio.aws.kafka.model.TopicReplication(
        copyAccessControlListsForTopics.map(value => value),
        copyTopicConfigurations.map(value => value),
        detectAndCopyNewTopics.map(value => value),
        topicsToExclude.map(value => value),
        topicsToReplicate
      )
    def copyAccessControlListsForTopics: Optional[__boolean]
    def copyTopicConfigurations: Optional[__boolean]
    def detectAndCopyNewTopics: Optional[__boolean]
    def topicsToExclude: Optional[List[__stringMax249]]
    def topicsToReplicate: List[__stringMax249]
    def getCopyAccessControlListsForTopics: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField(
        "copyAccessControlListsForTopics",
        copyAccessControlListsForTopics
      )
    def getCopyTopicConfigurations: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("copyTopicConfigurations", copyTopicConfigurations)
    def getDetectAndCopyNewTopics: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("detectAndCopyNewTopics", detectAndCopyNewTopics)
    def getTopicsToExclude: ZIO[Any, AwsError, List[__stringMax249]] =
      AwsError.unwrapOptionField("topicsToExclude", topicsToExclude)
    def getTopicsToReplicate: ZIO[Any, Nothing, List[__stringMax249]] =
      ZIO.succeed(topicsToReplicate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.TopicReplication
  ) extends zio.aws.kafka.model.TopicReplication.ReadOnly {
    override val copyAccessControlListsForTopics: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyAccessControlListsForTopics())
        .map(value => value: __boolean)
    override val copyTopicConfigurations: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTopicConfigurations())
        .map(value => value: __boolean)
    override val detectAndCopyNewTopics: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detectAndCopyNewTopics())
        .map(value => value: __boolean)
    override val topicsToExclude: Optional[List[__stringMax249]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicsToExclude())
        .map(value =>
          value.asScala.map { item =>
            item: __stringMax249
          }.toList
        )
    override val topicsToReplicate: List[__stringMax249] = impl
      .topicsToReplicate()
      .asScala
      .map { item =>
        item: __stringMax249
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.TopicReplication
  ): zio.aws.kafka.model.TopicReplication.ReadOnly = new Wrapper(impl)
}
