package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReplicationInfo(
    consumerGroupReplication: zio.aws.kafka.model.ConsumerGroupReplication,
    sourceKafkaClusterArn: __string,
    targetCompressionType: zio.aws.kafka.model.TargetCompressionType,
    targetKafkaClusterArn: __string,
    topicReplication: zio.aws.kafka.model.TopicReplication
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ReplicationInfo = {
    import ReplicationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ReplicationInfo
      .builder()
      .consumerGroupReplication(consumerGroupReplication.buildAwsValue())
      .sourceKafkaClusterArn(sourceKafkaClusterArn: java.lang.String)
      .targetCompressionType(targetCompressionType.unwrap)
      .targetKafkaClusterArn(targetKafkaClusterArn: java.lang.String)
      .topicReplication(topicReplication.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ReplicationInfo.ReadOnly =
    zio.aws.kafka.model.ReplicationInfo.wrap(buildAwsValue())
}
object ReplicationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ReplicationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ReplicationInfo =
      zio.aws.kafka.model.ReplicationInfo(
        consumerGroupReplication.asEditable,
        sourceKafkaClusterArn,
        targetCompressionType,
        targetKafkaClusterArn,
        topicReplication.asEditable
      )
    def consumerGroupReplication
        : zio.aws.kafka.model.ConsumerGroupReplication.ReadOnly
    def sourceKafkaClusterArn: __string
    def targetCompressionType: zio.aws.kafka.model.TargetCompressionType
    def targetKafkaClusterArn: __string
    def topicReplication: zio.aws.kafka.model.TopicReplication.ReadOnly
    def getConsumerGroupReplication: ZIO[
      Any,
      Nothing,
      zio.aws.kafka.model.ConsumerGroupReplication.ReadOnly
    ] = ZIO.succeed(consumerGroupReplication)
    def getSourceKafkaClusterArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceKafkaClusterArn)
    def getTargetCompressionType
        : ZIO[Any, Nothing, zio.aws.kafka.model.TargetCompressionType] =
      ZIO.succeed(targetCompressionType)
    def getTargetKafkaClusterArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(targetKafkaClusterArn)
    def getTopicReplication
        : ZIO[Any, Nothing, zio.aws.kafka.model.TopicReplication.ReadOnly] =
      ZIO.succeed(topicReplication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ReplicationInfo
  ) extends zio.aws.kafka.model.ReplicationInfo.ReadOnly {
    override val consumerGroupReplication
        : zio.aws.kafka.model.ConsumerGroupReplication.ReadOnly =
      zio.aws.kafka.model.ConsumerGroupReplication
        .wrap(impl.consumerGroupReplication())
    override val sourceKafkaClusterArn: __string =
      impl.sourceKafkaClusterArn(): __string
    override val targetCompressionType
        : zio.aws.kafka.model.TargetCompressionType =
      zio.aws.kafka.model.TargetCompressionType
        .wrap(impl.targetCompressionType())
    override val targetKafkaClusterArn: __string =
      impl.targetKafkaClusterArn(): __string
    override val topicReplication
        : zio.aws.kafka.model.TopicReplication.ReadOnly =
      zio.aws.kafka.model.TopicReplication.wrap(impl.topicReplication())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ReplicationInfo
  ): zio.aws.kafka.model.ReplicationInfo.ReadOnly = new Wrapper(impl)
}
