package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVpcConnectionsResponse(
    vpcConnections: Optional[Iterable[zio.aws.kafka.model.VpcConnection]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse = {
    import ListVpcConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse
      .builder()
      .optionallyWith(
        vpcConnections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcConnections)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListVpcConnectionsResponse.ReadOnly =
    zio.aws.kafka.model.ListVpcConnectionsResponse.wrap(buildAwsValue())
}
object ListVpcConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListVpcConnectionsResponse =
      zio.aws.kafka.model.ListVpcConnectionsResponse(
        vpcConnections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def vpcConnections
        : Optional[List[zio.aws.kafka.model.VpcConnection.ReadOnly]]
    def nextToken: Optional[__string]
    def getVpcConnections
        : ZIO[Any, AwsError, List[zio.aws.kafka.model.VpcConnection.ReadOnly]] =
      AwsError.unwrapOptionField("vpcConnections", vpcConnections)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse
  ) extends zio.aws.kafka.model.ListVpcConnectionsResponse.ReadOnly {
    override val vpcConnections
        : Optional[List[zio.aws.kafka.model.VpcConnection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConnections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.VpcConnection.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse
  ): zio.aws.kafka.model.ListVpcConnectionsResponse.ReadOnly = new Wrapper(impl)
}
