package zio.aws.kafka.model
import scala.jdk.CollectionConverters._
sealed trait VpcConnectionState {
  def unwrap: software.amazon.awssdk.services.kafka.model.VpcConnectionState
}
object VpcConnectionState {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.VpcConnectionState
  ): zio.aws.kafka.model.VpcConnectionState = value match {
    case software.amazon.awssdk.services.kafka.model.VpcConnectionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.VpcConnectionState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kafka.model.VpcConnectionState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.kafka.model.VpcConnectionState.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.kafka.model.VpcConnectionState.DEACTIVATING =>
      val r = DEACTIVATING
      r
    case software.amazon.awssdk.services.kafka.model.VpcConnectionState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kafka.model.VpcConnectionState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.kafka.model.VpcConnectionState.REJECTED =>
      val r = REJECTED
      r
    case software.amazon.awssdk.services.kafka.model.VpcConnectionState.REJECTING =>
      val r = REJECTING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kafka.model.VpcConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.VpcConnectionState =
      software.amazon.awssdk.services.kafka.model.VpcConnectionState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.kafka.model.VpcConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.VpcConnectionState =
      software.amazon.awssdk.services.kafka.model.VpcConnectionState.CREATING
  }
  case object AVAILABLE extends zio.aws.kafka.model.VpcConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.VpcConnectionState =
      software.amazon.awssdk.services.kafka.model.VpcConnectionState.AVAILABLE
  }
  case object INACTIVE extends zio.aws.kafka.model.VpcConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.VpcConnectionState =
      software.amazon.awssdk.services.kafka.model.VpcConnectionState.INACTIVE
  }
  case object DEACTIVATING extends zio.aws.kafka.model.VpcConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.VpcConnectionState =
      software.amazon.awssdk.services.kafka.model.VpcConnectionState.DEACTIVATING
  }
  case object DELETING extends zio.aws.kafka.model.VpcConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.VpcConnectionState =
      software.amazon.awssdk.services.kafka.model.VpcConnectionState.DELETING
  }
  case object FAILED extends zio.aws.kafka.model.VpcConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.VpcConnectionState =
      software.amazon.awssdk.services.kafka.model.VpcConnectionState.FAILED
  }
  case object REJECTED extends zio.aws.kafka.model.VpcConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.VpcConnectionState =
      software.amazon.awssdk.services.kafka.model.VpcConnectionState.REJECTED
  }
  case object REJECTING extends zio.aws.kafka.model.VpcConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.VpcConnectionState =
      software.amazon.awssdk.services.kafka.model.VpcConnectionState.REJECTING
  }
}
