package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KafkaClusterDescription(
    amazonMskCluster: Optional[zio.aws.kafka.model.AmazonMskCluster] =
      Optional.Absent,
    kafkaClusterAlias: Optional[__string] = Optional.Absent,
    vpcConfig: Optional[zio.aws.kafka.model.KafkaClusterClientVpcConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.KafkaClusterDescription = {
    import KafkaClusterDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.KafkaClusterDescription
      .builder()
      .optionallyWith(amazonMskCluster.map(value => value.buildAwsValue()))(
        _.amazonMskCluster
      )
      .optionallyWith(kafkaClusterAlias.map(value => value: java.lang.String))(
        _.kafkaClusterAlias
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.KafkaClusterDescription.ReadOnly =
    zio.aws.kafka.model.KafkaClusterDescription.wrap(buildAwsValue())
}
object KafkaClusterDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.KafkaClusterDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.KafkaClusterDescription =
      zio.aws.kafka.model.KafkaClusterDescription(
        amazonMskCluster.map(value => value.asEditable),
        kafkaClusterAlias.map(value => value),
        vpcConfig.map(value => value.asEditable)
      )
    def amazonMskCluster
        : Optional[zio.aws.kafka.model.AmazonMskCluster.ReadOnly]
    def kafkaClusterAlias: Optional[__string]
    def vpcConfig
        : Optional[zio.aws.kafka.model.KafkaClusterClientVpcConfig.ReadOnly]
    def getAmazonMskCluster
        : ZIO[Any, AwsError, zio.aws.kafka.model.AmazonMskCluster.ReadOnly] =
      AwsError.unwrapOptionField("amazonMskCluster", amazonMskCluster)
    def getKafkaClusterAlias: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("kafkaClusterAlias", kafkaClusterAlias)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.KafkaClusterClientVpcConfig.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.KafkaClusterDescription
  ) extends zio.aws.kafka.model.KafkaClusterDescription.ReadOnly {
    override val amazonMskCluster
        : Optional[zio.aws.kafka.model.AmazonMskCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amazonMskCluster())
        .map(value => zio.aws.kafka.model.AmazonMskCluster.wrap(value))
    override val kafkaClusterAlias: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.kafkaClusterAlias())
      .map(value => value: __string)
    override val vpcConfig
        : Optional[zio.aws.kafka.model.KafkaClusterClientVpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value =>
          zio.aws.kafka.model.KafkaClusterClientVpcConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.KafkaClusterDescription
  ): zio.aws.kafka.model.KafkaClusterDescription.ReadOnly = new Wrapper(impl)
}
