package zio.aws.kafka.model
import scala.jdk.CollectionConverters._
sealed trait ReplicatorState {
  def unwrap: software.amazon.awssdk.services.kafka.model.ReplicatorState
}
object ReplicatorState {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.ReplicatorState
  ): zio.aws.kafka.model.ReplicatorState = value match {
    case software.amazon.awssdk.services.kafka.model.ReplicatorState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.ReplicatorState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.kafka.model.ReplicatorState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kafka.model.ReplicatorState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.kafka.model.ReplicatorState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kafka.model.ReplicatorState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.kafka.model.ReplicatorState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ReplicatorState =
      software.amazon.awssdk.services.kafka.model.ReplicatorState.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.kafka.model.ReplicatorState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ReplicatorState =
      software.amazon.awssdk.services.kafka.model.ReplicatorState.RUNNING
  }
  case object CREATING extends zio.aws.kafka.model.ReplicatorState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ReplicatorState =
      software.amazon.awssdk.services.kafka.model.ReplicatorState.CREATING
  }
  case object UPDATING extends zio.aws.kafka.model.ReplicatorState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ReplicatorState =
      software.amazon.awssdk.services.kafka.model.ReplicatorState.UPDATING
  }
  case object DELETING extends zio.aws.kafka.model.ReplicatorState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ReplicatorState =
      software.amazon.awssdk.services.kafka.model.ReplicatorState.DELETING
  }
  case object FAILED extends zio.aws.kafka.model.ReplicatorState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ReplicatorState =
      software.amazon.awssdk.services.kafka.model.ReplicatorState.FAILED
  }
}
