package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClusterOperationResponse(
    clusterOperationInfo: Optional[zio.aws.kafka.model.ClusterOperationInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse = {
    import DescribeClusterOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse
      .builder()
      .optionallyWith(clusterOperationInfo.map(value => value.buildAwsValue()))(
        _.clusterOperationInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.DescribeClusterOperationResponse.ReadOnly =
    zio.aws.kafka.model.DescribeClusterOperationResponse.wrap(buildAwsValue())
}
object DescribeClusterOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DescribeClusterOperationResponse =
      zio.aws.kafka.model.DescribeClusterOperationResponse(
        clusterOperationInfo.map(value => value.asEditable)
      )
    def clusterOperationInfo
        : Optional[zio.aws.kafka.model.ClusterOperationInfo.ReadOnly]
    def getClusterOperationInfo: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClusterOperationInfo.ReadOnly
    ] = AwsError.unwrapOptionField("clusterOperationInfo", clusterOperationInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse
  ) extends zio.aws.kafka.model.DescribeClusterOperationResponse.ReadOnly {
    override val clusterOperationInfo
        : Optional[zio.aws.kafka.model.ClusterOperationInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterOperationInfo())
        .map(value => zio.aws.kafka.model.ClusterOperationInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse
  ): zio.aws.kafka.model.DescribeClusterOperationResponse.ReadOnly =
    new Wrapper(impl)
}
