package zio.aws.kafka.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__integer, __boolean}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProvisionedThroughput(
    enabled: Optional[__boolean] = Optional.Absent,
    volumeThroughput: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ProvisionedThroughput = {
    import ProvisionedThroughput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ProvisionedThroughput
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(volumeThroughput.map(value => value: Integer))(
        _.volumeThroughput
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ProvisionedThroughput.ReadOnly =
    zio.aws.kafka.model.ProvisionedThroughput.wrap(buildAwsValue())
}
object ProvisionedThroughput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ProvisionedThroughput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ProvisionedThroughput =
      zio.aws.kafka.model.ProvisionedThroughput(
        enabled.map(value => value),
        volumeThroughput.map(value => value)
      )
    def enabled: Optional[__boolean]
    def volumeThroughput: Optional[__integer]
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getVolumeThroughput: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("volumeThroughput", volumeThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ProvisionedThroughput
  ) extends zio.aws.kafka.model.ProvisionedThroughput.ReadOnly {
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
    override val volumeThroughput: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeThroughput())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ProvisionedThroughput
  ): zio.aws.kafka.model.ProvisionedThroughput.ReadOnly = new Wrapper(impl)
}
