package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__boolean, __stringMax256}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConsumerGroupReplication(
    consumerGroupsToExclude: Optional[Iterable[__stringMax256]] =
      Optional.Absent,
    consumerGroupsToReplicate: Iterable[__stringMax256],
    detectAndCopyNewConsumerGroups: Optional[__boolean] = Optional.Absent,
    synchroniseConsumerGroupOffsets: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ConsumerGroupReplication = {
    import ConsumerGroupReplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ConsumerGroupReplication
      .builder()
      .optionallyWith(
        consumerGroupsToExclude.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.consumerGroupsToExclude)
      .consumerGroupsToReplicate(consumerGroupsToReplicate.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        detectAndCopyNewConsumerGroups.map(value => value: java.lang.Boolean)
      )(_.detectAndCopyNewConsumerGroups)
      .optionallyWith(
        synchroniseConsumerGroupOffsets.map(value => value: java.lang.Boolean)
      )(_.synchroniseConsumerGroupOffsets)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ConsumerGroupReplication.ReadOnly =
    zio.aws.kafka.model.ConsumerGroupReplication.wrap(buildAwsValue())
}
object ConsumerGroupReplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ConsumerGroupReplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ConsumerGroupReplication =
      zio.aws.kafka.model.ConsumerGroupReplication(
        consumerGroupsToExclude.map(value => value),
        consumerGroupsToReplicate,
        detectAndCopyNewConsumerGroups.map(value => value),
        synchroniseConsumerGroupOffsets.map(value => value)
      )
    def consumerGroupsToExclude: Optional[List[__stringMax256]]
    def consumerGroupsToReplicate: List[__stringMax256]
    def detectAndCopyNewConsumerGroups: Optional[__boolean]
    def synchroniseConsumerGroupOffsets: Optional[__boolean]
    def getConsumerGroupsToExclude: ZIO[Any, AwsError, List[__stringMax256]] =
      AwsError.unwrapOptionField(
        "consumerGroupsToExclude",
        consumerGroupsToExclude
      )
    def getConsumerGroupsToReplicate: ZIO[Any, Nothing, List[__stringMax256]] =
      ZIO.succeed(consumerGroupsToReplicate)
    def getDetectAndCopyNewConsumerGroups: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField(
        "detectAndCopyNewConsumerGroups",
        detectAndCopyNewConsumerGroups
      )
    def getSynchroniseConsumerGroupOffsets: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField(
        "synchroniseConsumerGroupOffsets",
        synchroniseConsumerGroupOffsets
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ConsumerGroupReplication
  ) extends zio.aws.kafka.model.ConsumerGroupReplication.ReadOnly {
    override val consumerGroupsToExclude: Optional[List[__stringMax256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumerGroupsToExclude())
        .map(value =>
          value.asScala.map { item =>
            item: __stringMax256
          }.toList
        )
    override val consumerGroupsToReplicate: List[__stringMax256] = impl
      .consumerGroupsToReplicate()
      .asScala
      .map { item =>
        item: __stringMax256
      }
      .toList
    override val detectAndCopyNewConsumerGroups: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detectAndCopyNewConsumerGroups())
        .map(value => value: __boolean)
    override val synchroniseConsumerGroupOffsets: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.synchroniseConsumerGroupOffsets())
        .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ConsumerGroupReplication
  ): zio.aws.kafka.model.ConsumerGroupReplication.ReadOnly = new Wrapper(impl)
}
