package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ClusterOperationV2Summary(
    clusterArn: Optional[__string] = Optional.Absent,
    clusterType: Optional[zio.aws.kafka.model.ClusterType] = Optional.Absent,
    startTime: Optional[__timestampIso8601] = Optional.Absent,
    endTime: Optional[__timestampIso8601] = Optional.Absent,
    operationArn: Optional[__string] = Optional.Absent,
    operationState: Optional[__string] = Optional.Absent,
    operationType: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClusterOperationV2Summary = {
    import ClusterOperationV2Summary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClusterOperationV2Summary
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(clusterType.map(value => value.unwrap))(_.clusterType)
      .optionallyWith(startTime.map(value => value: Instant))(_.startTime)
      .optionallyWith(endTime.map(value => value: Instant))(_.endTime)
      .optionallyWith(operationArn.map(value => value: java.lang.String))(
        _.operationArn
      )
      .optionallyWith(operationState.map(value => value: java.lang.String))(
        _.operationState
      )
      .optionallyWith(operationType.map(value => value: java.lang.String))(
        _.operationType
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClusterOperationV2Summary.ReadOnly =
    zio.aws.kafka.model.ClusterOperationV2Summary.wrap(buildAwsValue())
}
object ClusterOperationV2Summary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ClusterOperationV2Summary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClusterOperationV2Summary =
      zio.aws.kafka.model.ClusterOperationV2Summary(
        clusterArn.map(value => value),
        clusterType.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        operationArn.map(value => value),
        operationState.map(value => value),
        operationType.map(value => value)
      )
    def clusterArn: Optional[__string]
    def clusterType: Optional[zio.aws.kafka.model.ClusterType]
    def startTime: Optional[__timestampIso8601]
    def endTime: Optional[__timestampIso8601]
    def operationArn: Optional[__string]
    def operationState: Optional[__string]
    def operationType: Optional[__string]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterType: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterType] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getStartTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationArn", operationArn)
    def getOperationState: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationState", operationState)
    def getOperationType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationType", operationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationV2Summary
  ) extends zio.aws.kafka.model.ClusterOperationV2Summary.ReadOnly {
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val clusterType: Optional[zio.aws.kafka.model.ClusterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterType())
        .map(value => zio.aws.kafka.model.ClusterType.wrap(value))
    override val startTime: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: __timestampIso8601)
    override val endTime: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: __timestampIso8601)
    override val operationArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operationArn())
      .map(value => value: __string)
    override val operationState: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operationState())
      .map(value => value: __string)
    override val operationType: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operationType())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationV2Summary
  ): zio.aws.kafka.model.ClusterOperationV2Summary.ReadOnly = new Wrapper(impl)
}
