package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ClientVpcConnection(
    authentication: Optional[__string] = Optional.Absent,
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    state: Optional[zio.aws.kafka.model.VpcConnectionState] = Optional.Absent,
    vpcConnectionArn: __string,
    owner: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClientVpcConnection = {
    import ClientVpcConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClientVpcConnection
      .builder()
      .optionallyWith(authentication.map(value => value: java.lang.String))(
        _.authentication
      )
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .vpcConnectionArn(vpcConnectionArn: java.lang.String)
      .optionallyWith(owner.map(value => value: java.lang.String))(_.owner)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClientVpcConnection.ReadOnly =
    zio.aws.kafka.model.ClientVpcConnection.wrap(buildAwsValue())
}
object ClientVpcConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ClientVpcConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClientVpcConnection =
      zio.aws.kafka.model.ClientVpcConnection(
        authentication.map(value => value),
        creationTime.map(value => value),
        state.map(value => value),
        vpcConnectionArn,
        owner.map(value => value)
      )
    def authentication: Optional[__string]
    def creationTime: Optional[__timestampIso8601]
    def state: Optional[zio.aws.kafka.model.VpcConnectionState]
    def vpcConnectionArn: __string
    def owner: Optional[__string]
    def getAuthentication: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("authentication", authentication)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.VpcConnectionState] =
      AwsError.unwrapOptionField("state", state)
    def getVpcConnectionArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(vpcConnectionArn)
    def getOwner: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("owner", owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClientVpcConnection
  ) extends zio.aws.kafka.model.ClientVpcConnection.ReadOnly {
    override val authentication: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.authentication())
      .map(value => value: __string)
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val state: Optional[zio.aws.kafka.model.VpcConnectionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.kafka.model.VpcConnectionState.wrap(value))
    override val vpcConnectionArn: __string = impl.vpcConnectionArn(): __string
    override val owner: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClientVpcConnection
  ): zio.aws.kafka.model.ClientVpcConnection.ReadOnly = new Wrapper(impl)
}
