package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListClustersResponse(
    clusterInfoList: Optional[Iterable[zio.aws.kafka.model.ClusterInfo]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClustersResponse = {
    import ListClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClustersResponse
      .builder()
      .optionallyWith(
        clusterInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterInfoList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListClustersResponse.ReadOnly =
    zio.aws.kafka.model.ListClustersResponse.wrap(buildAwsValue())
}
object ListClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClustersResponse =
      zio.aws.kafka.model.ListClustersResponse(
        clusterInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clusterInfoList
        : Optional[List[zio.aws.kafka.model.ClusterInfo.ReadOnly]]
    def nextToken: Optional[__string]
    def getClusterInfoList
        : ZIO[Any, AwsError, List[zio.aws.kafka.model.ClusterInfo.ReadOnly]] =
      AwsError.unwrapOptionField("clusterInfoList", clusterInfoList)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersResponse
  ) extends zio.aws.kafka.model.ListClustersResponse.ReadOnly {
    override val clusterInfoList
        : Optional[List[zio.aws.kafka.model.ClusterInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.ClusterInfo.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersResponse
  ): zio.aws.kafka.model.ListClustersResponse.ReadOnly = new Wrapper(impl)
}
