package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeConfigurationResponse(
    arn: Optional[__string] = Optional.Absent,
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    kafkaVersions: Optional[Iterable[__string]] = Optional.Absent,
    latestRevision: Optional[zio.aws.kafka.model.ConfigurationRevision] =
      Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    state: Optional[zio.aws.kafka.model.ConfigurationState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DescribeConfigurationResponse = {
    import DescribeConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DescribeConfigurationResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        kafkaVersions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.kafkaVersions)
      .optionallyWith(latestRevision.map(value => value.buildAwsValue()))(
        _.latestRevision
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.DescribeConfigurationResponse.ReadOnly =
    zio.aws.kafka.model.DescribeConfigurationResponse.wrap(buildAwsValue())
}
object DescribeConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DescribeConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DescribeConfigurationResponse =
      zio.aws.kafka.model.DescribeConfigurationResponse(
        arn.map(value => value),
        creationTime.map(value => value),
        description.map(value => value),
        kafkaVersions.map(value => value),
        latestRevision.map(value => value.asEditable),
        name.map(value => value),
        state.map(value => value)
      )
    def arn: Optional[__string]
    def creationTime: Optional[__timestampIso8601]
    def description: Optional[__string]
    def kafkaVersions: Optional[List[__string]]
    def latestRevision
        : Optional[zio.aws.kafka.model.ConfigurationRevision.ReadOnly]
    def name: Optional[__string]
    def state: Optional[zio.aws.kafka.model.ConfigurationState]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getKafkaVersions: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("kafkaVersions", kafkaVersions)
    def getLatestRevision: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ConfigurationRevision.ReadOnly
    ] = AwsError.unwrapOptionField("latestRevision", latestRevision)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ConfigurationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DescribeConfigurationResponse
  ) extends zio.aws.kafka.model.DescribeConfigurationResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val kafkaVersions: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.kafkaVersions())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val latestRevision
        : Optional[zio.aws.kafka.model.ConfigurationRevision.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestRevision())
        .map(value => zio.aws.kafka.model.ConfigurationRevision.wrap(value))
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val state: Optional[zio.aws.kafka.model.ConfigurationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.kafka.model.ConfigurationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DescribeConfigurationResponse
  ): zio.aws.kafka.model.DescribeConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
