package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutClusterPolicyResponse(
    currentVersion: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.PutClusterPolicyResponse = {
    import PutClusterPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.PutClusterPolicyResponse
      .builder()
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.PutClusterPolicyResponse.ReadOnly =
    zio.aws.kafka.model.PutClusterPolicyResponse.wrap(buildAwsValue())
}
object PutClusterPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.PutClusterPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.PutClusterPolicyResponse =
      zio.aws.kafka.model
        .PutClusterPolicyResponse(currentVersion.map(value => value))
    def currentVersion: Optional[__string]
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.PutClusterPolicyResponse
  ) extends zio.aws.kafka.model.PutClusterPolicyResponse.ReadOnly {
    override val currentVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.PutClusterPolicyResponse
  ): zio.aws.kafka.model.PutClusterPolicyResponse.ReadOnly = new Wrapper(impl)
}
